/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.synthetic.proto;

import io.mantisrx.common.codec.Codec;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectReader;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RequestEvent {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader requestEventReader = mapper.readerFor(RequestEvent.class);
    private final String userId;
    private final String uri;
    private final int status;
    private final String country;
    private final String deviceType;

    public Map<String, Object> toMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("userId", this.userId);
        data.put("uri", this.uri);
        data.put("status", this.status);
        data.put("country", this.country);
        data.put("deviceType", this.deviceType);
        return data;
    }

    public String toJsonString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Codec<RequestEvent> requestEventCodec() {
        return new Codec<RequestEvent>(){

            public RequestEvent decode(byte[] bytes) {
                try {
                    return (RequestEvent)requestEventReader.readValue(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public byte[] encode(RequestEvent value) {
                try {
                    return mapper.writeValueAsBytes((Object)value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @ConstructorProperties(value={"userId", "uri", "status", "country", "deviceType"})
    RequestEvent(String userId, String uri, int status, String country, String deviceType) {
        this.userId = userId;
        this.uri = uri;
        this.status = status;
        this.country = country;
        this.deviceType = deviceType;
    }

    public static RequestEventBuilder builder() {
        return new RequestEventBuilder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUri() {
        return this.uri;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCountry() {
        return this.country;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestEvent)) {
            return false;
        }
        RequestEvent other = (RequestEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        return !(this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        result = result * 59 + this.getStatus();
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        return result;
    }

    public String toString() {
        return "RequestEvent(userId=" + this.getUserId() + ", uri=" + this.getUri() + ", status=" + this.getStatus() + ", country=" + this.getCountry() + ", deviceType=" + this.getDeviceType() + ")";
    }

    public static class RequestEventBuilder {
        private String userId;
        private String uri;
        private int status;
        private String country;
        private String deviceType;

        RequestEventBuilder() {
        }

        public RequestEventBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public RequestEventBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public RequestEventBuilder status(int status) {
            this.status = status;
            return this;
        }

        public RequestEventBuilder country(String country) {
            this.country = country;
            return this;
        }

        public RequestEventBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public RequestEvent build() {
            return new RequestEvent(this.userId, this.uri, this.status, this.country, this.deviceType);
        }

        public String toString() {
            return "RequestEvent.RequestEventBuilder(userId=" + this.userId + ", uri=" + this.uri + ", status=" + this.status + ", country=" + this.country + ", deviceType=" + this.deviceType + ")";
        }
    }
}

