/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mantis.examples.sinefunction;

import io.mantisrx.mantis.examples.sinefunction.SineFunctionJob;
import io.mantisrx.mantis.examples.sinefunction.core.Point;
import io.mantisrx.runtime.Config;
import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.core.MantisStream;
import io.mantisrx.runtime.core.WindowSpec;
import io.mantisrx.runtime.core.functions.ReduceFunction;
import io.mantisrx.runtime.core.functions.ReduceFunctionImpl;
import io.mantisrx.runtime.core.sinks.ObservableSinkImpl;
import io.mantisrx.runtime.core.sinks.SinkFunction;
import io.mantisrx.runtime.core.sources.ObservableSourceImpl;
import io.mantisrx.runtime.core.sources.SourceFunction;
import io.mantisrx.runtime.executor.LocalJobExecutorNetworked;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.runtime.parameter.type.BooleanParameter;
import io.mantisrx.runtime.parameter.type.DoubleParameter;
import io.mantisrx.runtime.parameter.type.IntParameter;
import io.mantisrx.runtime.parameter.validator.Validators;
import io.mantisrx.runtime.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SineFunction {
    private static final Logger log = LoggerFactory.getLogger(SineFunction.class);

    public static void main(String[] args) {
        double amplitude = 5.0;
        double frequency = 1.0;
        double phase = 0.0;
        Config jobConfig = MantisStream.create(null).source((SourceFunction)new ObservableSourceImpl((Source)new SineFunctionJob.TimerSource())).filter(x -> x % 2 == 0).map(x -> new Point(x.intValue(), 5.0 * Math.sin(1.0 * (double)x.intValue() + 0.0))).keyBy(x -> x.getX() % 10.0).window(WindowSpec.count((int)2)).reduce((ReduceFunction)((ReduceFunctionImpl)(acc, i) -> {
            Point point = new Point(acc.getX() + i.getX(), i.getY());
            log.info("received point ({}, {}) -> ({}, {})", new Object[]{i.getX(), i.getY(), point.getX(), point.getY()});
            return point;
        })).sink((SinkFunction)new ObservableSinkImpl(SineFunctionJob.sseSink));
        Job pointJob = jobConfig.parameterDefinition(new BooleanParameter().name("useRandom").defaultValue((Object)false).description("If true, produce a random sequence of integers.  If false, produce a sequence of integers starting at 0 and increasing by 1.").build()).parameterDefinition(new DoubleParameter().name("randomRate").defaultValue((Object)1.0).description("The chance a random integer is generated, for the given period").validator(Validators.range((Number)0, (Number)1)).build()).parameterDefinition(new IntParameter().name("intervalSec").defaultValue((Object)1).description("Period at which to generate a random integer value to send to sine function").validator(Validators.range((Number)1, (Number)60)).build()).parameterDefinition(new IntParameter().name("min").defaultValue((Object)0).description("Minimun of random integer value").validator(Validators.range((Number)0, (Number)100)).build()).parameterDefinition(new IntParameter().name("max").defaultValue((Object)100).description("Maximum of random integer value").validator(Validators.range((Number)1, (Number)100)).build()).create();
        LocalJobExecutorNetworked.execute((Job)pointJob, (Parameter[])new Parameter[0]);
    }
}

