/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.examples.mantispublishsample.web.filter;

import com.netflix.mantis.examples.mantispublishsample.web.filter.CaptureRequestEventFilter;
import io.mantisrx.publish.api.Event;
import io.mantisrx.publish.api.EventPublisher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CaptureRequestEventFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CaptureRequestEventFilter.class);
    private static final String RESPONSE_HEADER_PREFIX = "response.header.";
    private static final String REQUEST_HEADER_PREFIX = "request.header.";
    private static final String VALUE_SEPARATOR = ",";
    @Inject
    private EventPublisher publisher;

    public void init(FilterConfig filterConfig) {
        log.info("Capture Request data filter inited");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        log.debug("In do filter");
        long startMillis = System.currentTimeMillis();
        ResponseSpy responseSpy = new ResponseSpy(res, null);
        filterChain.doFilter(servletRequest, (ServletResponse)responseSpy);
        this.processPostFilter(startMillis, req, responseSpy);
    }

    private void processPostFilter(long startMillis, HttpServletRequest req, ResponseSpy responseSpy) {
        try {
            HashMap event = new HashMap();
            this.postProcess(req, responseSpy, event);
            Event rEvent = new Event(event);
            long duration = System.currentTimeMillis() - startMillis;
            rEvent.set("duration", (Object)duration);
            log.info("sending event {} to stream {}", (Object)rEvent);
            CompletionStage sendResult = this.publisher.publish(rEvent);
            sendResult.whenCompleteAsync((status, throwable) -> log.info("Filter send event status=> {}", status));
        }
        catch (Exception e) {
            log.error("failed to process event", (Throwable)e);
        }
    }

    private void postProcess(HttpServletRequest httpServletRequest, ResponseSpy responseSpy, Map<String, Object> event) {
        try {
            int rdm = ThreadLocalRandom.current().nextInt();
            if (rdm < 0) {
                rdm *= -1;
            }
            event.put("request.uuid", rdm);
            this.captureRequestData(event, httpServletRequest);
            this.captureResponseData(event, responseSpy);
        }
        catch (Exception e) {
            event.put("exception", e.toString());
            log.error("Error capturing data in api.RequestEventInfoCollector filter! uri=" + httpServletRequest.getRequestURI(), (Throwable)e);
        }
    }

    private void captureResponseData(Map<String, Object> event, ResponseSpy res) {
        log.debug("Capturing response data");
        for (String name : res.headers.keySet()) {
            StringBuilder valBuilder = new StringBuilder();
            boolean firstValue = true;
            for (String s : (List)res.headers.get(name)) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    valBuilder.append(VALUE_SEPARATOR);
                }
                valBuilder.append(s);
            }
            event.put(RESPONSE_HEADER_PREFIX + name, valBuilder.toString());
        }
        if (!res.cookies.isEmpty()) {
            Iterator cookies = res.cookies.iterator();
            StringBuilder setCookies = new StringBuilder();
            while (cookies.hasNext()) {
                String path;
                int maxAge;
                Cookie cookie = (Cookie)cookies.next();
                setCookies.append(cookie.getName()).append("=").append(cookie.getValue());
                String domain = cookie.getDomain();
                if (domain != null) {
                    setCookies.append("; Domain=").append(domain);
                }
                if ((maxAge = cookie.getMaxAge()) >= 0) {
                    setCookies.append("; Max-Age=").append(maxAge);
                }
                if ((path = cookie.getPath()) != null) {
                    setCookies.append("; Path=").append(path);
                }
                if (cookie.getSecure()) {
                    setCookies.append("; Secure");
                }
                if (cookie.isHttpOnly()) {
                    setCookies.append("; HttpOnly");
                }
                if (!cookies.hasNext()) continue;
                setCookies.append(VALUE_SEPARATOR);
            }
            event.put("response.header.set-cookie", setCookies.toString());
        }
        int status = res.statusCode;
        event.put("status", status);
    }

    private void captureRequestData(Map<String, Object> event, HttpServletRequest req) {
        String path = req.getRequestURI();
        if (path == null) {
            path = "/";
        }
        event.put("path", path);
        event.put("host", req.getHeader("host"));
        event.put("query", req.getQueryString());
        event.put("method", req.getMethod());
        event.put("currentTime", System.currentTimeMillis());
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            StringBuilder valBuilder = new StringBuilder();
            boolean firstValue = true;
            Enumeration vals = req.getHeaders(name);
            while (vals.hasMoreElements()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    valBuilder.append(VALUE_SEPARATOR);
                }
                valBuilder.append((String)vals.nextElement());
            }
            event.put(REQUEST_HEADER_PREFIX + name, valBuilder.toString());
        }
        if ("GET".equals(req.getMethod())) {
            Map params = req.getParameterMap();
            for (Object key : params.keySet()) {
                String[] valArray;
                String keyString = key.toString();
                Object val = params.get(key);
                String valString = val instanceof String[] ? ((valArray = (String[])val).length == 1 ? valArray[0] : Arrays.asList((String[])val).toString()) : val.toString();
                event.put("param." + key, valString);
            }
        }
    }

    public void destroy() {
    }
}

