/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.samples.proto;

import io.mantisrx.common.codec.Codec;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectReader;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;

public class RequestEvent
implements Serializable {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader requestEventReader = mapper.readerFor(RequestEvent.class);
    private final String requestPath;
    private final String ipAddress;
    private final int latency;

    public static Codec<RequestEvent> requestEventCodec() {
        return new Codec<RequestEvent>(){

            public RequestEvent decode(byte[] bytes) {
                try {
                    return (RequestEvent)requestEventReader.readValue(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public byte[] encode(RequestEvent value) {
                try {
                    return mapper.writeValueAsBytes((Object)value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @ConstructorProperties(value={"requestPath", "ipAddress", "latency"})
    RequestEvent(String requestPath, String ipAddress, int latency) {
        this.requestPath = requestPath;
        this.ipAddress = ipAddress;
        this.latency = latency;
    }

    public static RequestEventBuilder builder() {
        return new RequestEventBuilder();
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getLatency() {
        return this.latency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestEvent)) {
            return false;
        }
        RequestEvent other = (RequestEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLatency() != other.getLatency()) {
            return false;
        }
        String this$requestPath = this.getRequestPath();
        String other$requestPath = other.getRequestPath();
        if (this$requestPath == null ? other$requestPath != null : !this$requestPath.equals(other$requestPath)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        return !(this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLatency();
        String $requestPath = this.getRequestPath();
        result = result * 59 + ($requestPath == null ? 43 : $requestPath.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        return result;
    }

    public String toString() {
        return "RequestEvent(requestPath=" + this.getRequestPath() + ", ipAddress=" + this.getIpAddress() + ", latency=" + this.getLatency() + ")";
    }

    public static class RequestEventBuilder {
        private String requestPath;
        private String ipAddress;
        private int latency;

        RequestEventBuilder() {
        }

        public RequestEventBuilder requestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public RequestEventBuilder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public RequestEventBuilder latency(int latency) {
            this.latency = latency;
            return this;
        }

        public RequestEvent build() {
            return new RequestEvent(this.requestPath, this.ipAddress, this.latency);
        }

        public String toString() {
            return "RequestEvent.RequestEventBuilder(requestPath=" + this.requestPath + ", ipAddress=" + this.ipAddress + ", latency=" + this.latency + ")";
        }
    }
}

