/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.samples.stage;

import com.netflix.mantis.samples.proto.AggregationReport;
import com.netflix.mantis.samples.proto.RequestAggregation;
import io.mantisrx.common.codec.Codecs;
import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.ScalarToScalar;
import io.mantisrx.runtime.computation.ScalarComputation;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class CollectStage
implements ScalarComputation<RequestAggregation, String> {
    private static final Logger log = LoggerFactory.getLogger(CollectStage.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public Observable<String> call(Context context, Observable<RequestAggregation> requestAggregationO) {
        return requestAggregationO.window(5L, TimeUnit.SECONDS).flatMap(requestAggO -> requestAggO.reduce((Object)new RequestAggregationAccumulator(), (acc, requestAgg) -> acc.addAggregation((RequestAggregation)requestAgg)).map(RequestAggregationAccumulator::generateReport).doOnNext(report -> log.debug("Generated Collection report {}", report))).map(report -> {
            try {
                return mapper.writeValueAsString(report);
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull);
    }

    public void init(Context context) {
    }

    public static ScalarToScalar.Config<RequestAggregation, String> config() {
        return new ScalarToScalar.Config().codec(Codecs.string());
    }

    static class RequestAggregationAccumulator {
        private final Map<String, Integer> pathToCountMap = new HashMap<String, Integer>();

        public RequestAggregationAccumulator addAggregation(RequestAggregation agg) {
            this.pathToCountMap.put(agg.getPath(), agg.getCount());
            return this;
        }

        public AggregationReport generateReport() {
            log.info("Generated report from=> {}", this.pathToCountMap);
            return new AggregationReport(this.pathToCountMap);
        }
    }
}

