/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.samples.stage;

import com.netflix.mantis.samples.proto.RequestEvent;
import io.mantisrx.common.MantisGroup;
import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.ScalarToGroup;
import io.mantisrx.runtime.computation.ToGroupComputation;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.mantisrx.runtime.parameter.type.StringParameter;
import io.mantisrx.runtime.parameter.validator.Validators;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class GroupByStage
implements ToGroupComputation<RequestEvent, String, RequestEvent> {
    private static final Logger log = LoggerFactory.getLogger(GroupByStage.class);
    private static final String GROUPBY_FIELD_PARAM = "groupByField";
    private boolean groupByPath = true;

    public Observable<MantisGroup<String, RequestEvent>> call(Context context, Observable<RequestEvent> requestEventO) {
        return requestEventO.map(requestEvent -> {
            if (this.groupByPath) {
                return new MantisGroup((Object)requestEvent.getRequestPath(), requestEvent);
            }
            return new MantisGroup((Object)requestEvent.getIpAddress(), requestEvent);
        });
    }

    public void init(Context context) {
        String groupByField = (String)context.getParameters().get(GROUPBY_FIELD_PARAM, (Object)"path");
        this.groupByPath = groupByField.equalsIgnoreCase("path");
    }

    public static List<ParameterDefinition<?>> getParameters() {
        ArrayList params = new ArrayList();
        params.add(new StringParameter().name(GROUPBY_FIELD_PARAM).description("The key to group events by").validator(Validators.notNullOrEmpty()).defaultValue((Object)"path").build());
        return params;
    }

    public static ScalarToGroup.Config<RequestEvent, String, RequestEvent> config() {
        return new ScalarToGroup.Config().description("Group event data by path/ip").concurrentInput().withParameters(GroupByStage.getParameters()).codec(RequestEvent.requestEventCodec());
    }
}

