/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.samples.proto;

import io.mantisrx.common.codec.Codec;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectReader;
import java.beans.ConstructorProperties;
import java.io.IOException;

public class RequestAggregation {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectReader requestAggregationReader = mapper.readerFor(RequestAggregation.class);
    private String path;
    private int count;

    public static Codec<RequestAggregation> requestAggregationCodec() {
        return new Codec<RequestAggregation>(){

            public RequestAggregation decode(byte[] bytes) {
                try {
                    return (RequestAggregation)requestAggregationReader.readValue(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public byte[] encode(RequestAggregation value) {
                try {
                    return mapper.writeValueAsBytes((Object)value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @ConstructorProperties(value={"path", "count"})
    RequestAggregation(String path, int count) {
        this.path = path;
        this.count = count;
    }

    public static RequestAggregationBuilder builder() {
        return new RequestAggregationBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public int getCount() {
        return this.count;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestAggregation)) {
            return false;
        }
        RequestAggregation other = (RequestAggregation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestAggregation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + this.getCount();
        return result;
    }

    public String toString() {
        return "RequestAggregation(path=" + this.getPath() + ", count=" + this.getCount() + ")";
    }

    public static class RequestAggregationBuilder {
        private String path;
        private int count;

        RequestAggregationBuilder() {
        }

        public RequestAggregationBuilder path(String path) {
            this.path = path;
            return this;
        }

        public RequestAggregationBuilder count(int count) {
            this.count = count;
            return this;
        }

        public RequestAggregation build() {
            return new RequestAggregation(this.path, this.count);
        }

        public String toString() {
            return "RequestAggregation.RequestAggregationBuilder(path=" + this.path + ", count=" + this.count + ")";
        }
    }
}

