/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.discovery.proto;

import com.netflix.mantis.discovery.proto.StageWorkers;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class JobDiscoveryInfo {
    @JsonIgnore
    private static final int INGEST_STAGE = 1;
    private final String jobCluster;
    private final String jobId;
    private final Map<Integer, StageWorkers> stageWorkersMap;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobDiscoveryInfo(@JsonProperty(value="jobCluster") String jobCluster, @JsonProperty(value="jobId") String jobId, @JsonProperty(value="stageWorkersMap") Map<Integer, StageWorkers> stageWorkersMap) {
        this.jobCluster = jobCluster;
        this.jobId = jobId;
        this.stageWorkersMap = stageWorkersMap;
    }

    public String getJobCluster() {
        return this.jobCluster;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Map<Integer, StageWorkers> getStageWorkersMap() {
        return this.stageWorkersMap;
    }

    @JsonIgnore
    public StageWorkers getIngestStageWorkers() {
        return this.stageWorkersMap.getOrDefault(1, new StageWorkers(this.jobCluster, this.jobId, 1, Collections.emptyList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDiscoveryInfo that = (JobDiscoveryInfo)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.stageWorkersMap, that.stageWorkersMap);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.stageWorkersMap);
    }

    public String toString() {
        return "JobDiscoveryInfo{ jobCluster='" + this.jobCluster + '\'' + ", jobId='" + this.jobId + '\'' + ", stageWorkersMap=" + this.stageWorkersMap + '}';
    }
}

