/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.discovery.proto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetSocketAddress;
import java.util.Objects;

public class MantisWorker {
    private final String host;
    private final int port;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisWorker(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantisWorker that = (MantisWorker)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return "MantisWorker{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    public InetSocketAddress toInetSocketAddress() {
        return InetSocketAddress.createUnresolved(this.host, this.port);
    }

    public int size() {
        return this.host.getBytes().length + 4;
    }
}

