/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.mantis.discovery.proto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.mantis.discovery.proto.StreamJobClusterMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AppJobClustersMap {
    public static final String VERSION_1 = "1";
    public static final String DEFAULT_APP_KEY = "__default__";
    private long timestamp;
    private final Map<String, Map<String, String>> mappings = new HashMap<String, Map<String, String>>();
    private String version = "1";

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public AppJobClustersMap(@JsonProperty(value="version") String version, @JsonProperty(value="timestamp") long ts, @JsonProperty(value="mappings") Map<String, Object> mappings) {
        AppJobClustersMap.checkNotNull(mappings, "mappings");
        AppJobClustersMap.checkNotNull(version, "version");
        this.timestamp = ts;
        if (!version.equals(VERSION_1)) {
            throw new IllegalArgumentException("version " + version + " is not supported");
        }
        this.version = version;
        mappings.entrySet().stream().forEach(e -> this.mappings.put((String)e.getKey(), (Map)e.getValue()));
    }

    public AppJobClustersMap() {
    }

    @JsonIgnore
    public static <T> T checkNotNull(T obj, String name) {
        if (obj == null) {
            String msg = String.format("parameter '%s' cannot be null", name);
            throw new NullPointerException(msg);
        }
        return obj;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Map<String, String>> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonIgnore
    private Map<String, String> defaultStreamJobClusterMap() {
        return this.mappings.getOrDefault(DEFAULT_APP_KEY, Collections.emptyMap());
    }

    @JsonIgnore
    public StreamJobClusterMap getStreamJobClusterMap(String appName) {
        Map<String, String> mappings = this.mappings.getOrDefault(appName, this.defaultStreamJobClusterMap());
        return new StreamJobClusterMap(appName, mappings);
    }

    @JsonIgnore
    public AppJobClustersMap getFilteredAppJobClustersMap(List<String> apps) {
        Builder builder = new Builder();
        builder = builder.withVersion(this.version);
        builder = builder.withTimestamp(this.timestamp);
        if (apps != null) {
            for (String appName : apps) {
                builder = builder.withAppJobCluster(appName, this.getStreamJobClusterMap(appName));
            }
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppJobClustersMap that = (AppJobClustersMap)o;
        return this.timestamp == that.timestamp && this.version.equals(that.version) && this.mappings.equals(that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp, this.mappings);
    }

    public String toString() {
        return "AppJobClustersMap{version='" + this.version + '\'' + ", timestamp=" + this.timestamp + ", mappings=" + this.mappings + '}';
    }

    static class Builder {
        private final Map<String, Object> mappings = new HashMap<String, Object>();
        private String version;
        private long ts = -1L;

        Builder() {
        }

        Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        Builder withTimestamp(long ts) {
            this.ts = ts;
            return this;
        }

        Builder withAppJobCluster(String appName, StreamJobClusterMap streamJobCluster) {
            this.mappings.put(appName, streamJobCluster.getStreamJobClusterMap());
            return this;
        }

        public AppJobClustersMap build() {
            if (this.version == null) {
                throw new IllegalArgumentException("version cannot be null when creating AppJobClustersMap");
            }
            if (this.ts == -1L) {
                throw new IllegalArgumentException("timestamp not specified when creating AppJobClustersMap");
            }
            return new AppJobClustersMap(this.version, this.ts, this.mappings);
        }
    }
}

