/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.store;

import io.mantisrx.server.master.store.KeyValueStore;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class DynamoStore
implements KeyValueStore {
    private static final Logger log = LoggerFactory.getLogger(DynamoStore.class);
    public static final String PK = "PK";
    public static final String SK = "SK";
    public static final String PARTITION_KEY = "partitionKey";
    public static final String SECONDARY_KEY = "secondaryKey";
    public static final String TABLE_NAME_KEY = "tableName";
    public static final String TTL_KEY = "expiresAt";
    public static final String DATA_KEY = "data";
    private static final String PK_E = "#PK";
    private static final String PK_V = ":PK";
    private static final String SK_E = "#SK";
    private static final String SK_V = ":SK";
    private static final String MPK_E = "#MPK";
    private static final int MAX_ITEMS = 25;
    private final String mantisTable;
    private final DynamoDbClient client;

    public DynamoStore() {
        this.client = (DynamoDbClient)DynamoDbClient.builder().build();
        this.mantisTable = "mantis-key-value-store";
    }

    public DynamoStore(DynamoDbClient client, String tableName) {
        this.client = client;
        this.mantisTable = tableName;
    }

    public List<String> getAllPartitionKeys(String tableName) throws IOException {
        HashMap<String, String> expressionAttributesNames = new HashMap<String, String>();
        expressionAttributesNames.put(PK_E, PK);
        expressionAttributesNames.put(MPK_E, PARTITION_KEY);
        HashMap<String, Object> expressionAttributeValues = new HashMap<String, Object>();
        expressionAttributeValues.put(PK_V, AttributeValue.builder().s(tableName).build());
        QueryRequest request = (QueryRequest)QueryRequest.builder().tableName(this.mantisTable).keyConditionExpression(String.format("%s = %s", PK_E, PK_V)).expressionAttributeNames(expressionAttributesNames).expressionAttributeValues(expressionAttributeValues).projectionExpression(MPK_E).build();
        log.info("querying for all partition keys in table {}", (Object)tableName);
        QueryResponse response = this.client.query(request);
        HashMap pks = new HashMap();
        response.items().forEach(v -> pks.put(((AttributeValue)v.get(PARTITION_KEY)).s(), ""));
        return new ArrayList<String>(pks.keySet());
    }

    public Map<String, String> getAll(String tableName, String partitionKey) throws IOException {
        HashMap<String, String> expressionAttributesNames = new HashMap<String, String>();
        expressionAttributesNames.put(PK_E, PK);
        expressionAttributesNames.put(SK_E, SK);
        HashMap<String, Object> expressionAttributeValues = new HashMap<String, Object>();
        expressionAttributeValues.put(PK_V, AttributeValue.builder().s(tableName).build());
        expressionAttributeValues.put(SK_V, AttributeValue.builder().s(partitionKey).build());
        QueryRequest request = (QueryRequest)QueryRequest.builder().tableName(this.mantisTable).keyConditionExpression(String.format("%s = %s and begins_with(%s, %s)", PK_E, PK_V, SK_E, SK_V)).expressionAttributeNames(expressionAttributesNames).expressionAttributeValues(expressionAttributeValues).build();
        log.info("querying for all items in partition {} in table {}", (Object)partitionKey, (Object)tableName);
        QueryResponse response = this.client.query(request);
        HashMap<String, String> items = new HashMap<String, String>();
        response.items().forEach(v -> items.put(((AttributeValue)v.get(SECONDARY_KEY)).s(), ((AttributeValue)v.get(DATA_KEY)).s()));
        return items;
    }

    public boolean upsertAll(String tableName, String partitionKey, Map<String, String> all, Duration ttl) throws IOException {
        Duration expiresIn = ttl == null || ttl.isZero() ? Duration.ZERO : ttl;
        List<WriteRequest> writeRequests = this.writeRequestsFrom(tableName, partitionKey, all, expiresIn);
        return this.doBatchWriteRequest(writeRequests);
    }

    public boolean delete(String tableName, String partitionKey, String secondaryKey) throws IOException {
        HashMap<String, Object> expressionAttributeValues = new HashMap<String, Object>();
        expressionAttributeValues.put(PK, AttributeValue.builder().s(tableName).build());
        expressionAttributeValues.put(SK, AttributeValue.builder().s(partitionKey + "#" + secondaryKey).build());
        DeleteItemRequest request = (DeleteItemRequest)DeleteItemRequest.builder().tableName(tableName).key(expressionAttributeValues).build();
        DeleteItemResponse response = this.client.deleteItem(request);
        response.responseMetadata().requestId();
        log.info("deleted item from table [{}], pk[{}], sk[{}] with request ID {}", new Object[]{tableName, partitionKey, secondaryKey, response.responseMetadata().requestId()});
        return true;
    }

    public boolean deleteAll(String tableName, String partitionKey) throws IOException {
        HashMap<String, String> expressionAttributesNames = new HashMap<String, String>();
        expressionAttributesNames.put(PK_E, PK);
        expressionAttributesNames.put(SK_E, SK);
        HashMap<String, Object> expressionAttributeValues = new HashMap<String, Object>();
        expressionAttributeValues.put(PK_V, AttributeValue.builder().s(tableName).build());
        expressionAttributeValues.put(SK_V, AttributeValue.builder().s(partitionKey).build());
        QueryRequest request = (QueryRequest)QueryRequest.builder().tableName(this.mantisTable).keyConditionExpression(String.format("%s = %s and begins_with(%s, %s)", PK_E, PK_V, SK_E, SK_V)).expressionAttributeNames(expressionAttributesNames).expressionAttributeValues(expressionAttributeValues).build();
        log.info("querying for all items in partition {} in table {}", (Object)partitionKey, (Object)tableName);
        QueryResponse response = this.client.query(request);
        ArrayList<WriteRequest> deleteRequests = new ArrayList<WriteRequest>();
        log.info("retrieved {} from {} and {}", new Object[]{response.items().size(), tableName, partitionKey});
        response.items().forEach(v -> deleteRequests.add((WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key((Map)ImmutableMap.of((Object)PK, (Object)AttributeValue.builder().s(((AttributeValue)v.get(PK)).s()).build(), (Object)SK, (Object)AttributeValue.builder().s(((AttributeValue)v.get(SK)).s()).build())).build()).build()));
        this.doBatchWriteRequest(deleteRequests);
        log.info("deleted {} from {} and {}", new Object[]{deleteRequests.size(), tableName, partitionKey});
        return true;
    }

    private WriteRequest writeRequestFrom(String tableName, String partitionKey, String secondaryKey, String data, Duration ttl) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put(PK, AttributeValue.builder().s(tableName).build());
        items.put(SK, AttributeValue.builder().s(String.format("%s#%s", partitionKey, secondaryKey)).build());
        items.put(DATA_KEY, AttributeValue.builder().s(data).build());
        items.put(PARTITION_KEY, AttributeValue.builder().s(partitionKey).build());
        items.put(SECONDARY_KEY, AttributeValue.builder().s(secondaryKey).build());
        items.put(TABLE_NAME_KEY, AttributeValue.builder().s(tableName).build());
        if (!ttl.isZero()) {
            items.put(TTL_KEY, AttributeValue.builder().n(String.valueOf(System.currentTimeMillis() / 1000L + ttl.getSeconds())).build());
        }
        return (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(items).build()).build();
    }

    private List<WriteRequest> writeRequestsFrom(String tableName, String partitionKey, Map<String, String> mapSKToData, Duration ttl) {
        ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>();
        mapSKToData.forEach((key, value) -> writeRequests.add(this.writeRequestFrom(tableName, partitionKey, (String)key, (String)value, ttl)));
        return writeRequests;
    }

    private WriteRequest deleteRequestFrom(String tableName, String partitionKey, String secondaryKey) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put(PK, AttributeValue.builder().s(tableName).build());
        items.put(SK, AttributeValue.builder().s(String.format("%s#%s", partitionKey, secondaryKey)).build());
        return (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(items).build()).build();
    }

    private WriteRequest deleteRequestFrom(String dyanmoPK, String dynamoSK) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        log.info("preparing to delete pk {} sk {}", (Object)dyanmoPK, (Object)dynamoSK);
        items.put(PK, AttributeValue.builder().s(dyanmoPK).build());
        items.put(SK, AttributeValue.builder().s(dynamoSK).build());
        return (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(items).build()).build();
    }

    private List<WriteRequest> deleteRequestsFrom(Map<String, String> mapPKSK) {
        ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>();
        mapPKSK.forEach((key, value) -> writeRequests.add(this.deleteRequestFrom((String)key, (String)value)));
        return writeRequests;
    }

    private boolean doBatchWriteRequest(List<WriteRequest> writeRequests) throws IOException {
        for (int i = 0; i < writeRequests.size(); i += 25) {
            List<WriteRequest> writes = writeRequests.subList(i, Integer.min(i + 25, writeRequests.size()));
            log.info("processing {} items to {}", (Object)writes.size(), (Object)this.mantisTable);
            BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems((Map)ImmutableMap.of((Object)this.mantisTable, writes)).build();
            BatchWriteItemResponse batchWriteItemResponse = this.client.batchWriteItem(batchWriteItemRequest);
            while (!batchWriteItemResponse.hasUnprocessedItems()) {
                Map unprocessedItems = batchWriteItemResponse.unprocessedItems();
                log.warn("handling {} unprocessed items", (Object)unprocessedItems.size());
                batchWriteItemResponse = this.client.batchWriteItem(batchWriteItemRequest);
            }
        }
        return true;
    }
}

