/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.utils;

import io.mantisrx.common.properties.MantisPropertiesLoader;
import io.mantisrx.config.dynamic.LongDynamicProperty;
import io.mantisrx.config.dynamic.StringDynamicProperty;
import io.mantisrx.server.core.CoreConfiguration;
import java.lang.reflect.Method;
import org.skife.config.Config;

public class ConfigUtils {
    private static StringDynamicProperty getDynamicPropertyString(Method method, String defaultValue, MantisPropertiesLoader loader) {
        String propertyKey = ConfigUtils.retrievePropertyKey(method);
        return new StringDynamicProperty(loader, propertyKey, defaultValue);
    }

    public static StringDynamicProperty getDynamicPropertyString(String name, Class<? extends CoreConfiguration> clazz, String defaultValue, MantisPropertiesLoader loader) {
        return ConfigUtils.getDynamicPropertyString(ConfigUtils.getMethodFromName(name, clazz), defaultValue, loader);
    }

    private static LongDynamicProperty getDynamicPropertyLong(Method method, long defaultValue, MantisPropertiesLoader loader) {
        String propertyKey = ConfigUtils.retrievePropertyKey(method);
        return new LongDynamicProperty(loader, propertyKey, Long.valueOf(defaultValue));
    }

    public static LongDynamicProperty getDynamicPropertyLong(String name, Class<? extends CoreConfiguration> clazz, long defaultValue, MantisPropertiesLoader loader) {
        return ConfigUtils.getDynamicPropertyLong(ConfigUtils.getMethodFromName(name, clazz), defaultValue, loader);
    }

    public static Method getMethodFromName(String name, Class<? extends CoreConfiguration> clazz) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("invalid name: " + name + " for " + clazz.getSimpleName());
        }
    }

    private static String retrievePropertyKey(Method method) {
        Config configAnnotation = method.getAnnotation(Config.class);
        String[] values = configAnnotation.value();
        if (values.length != 1) {
            throw new RuntimeException("invalid annotation on: " + method.getName());
        }
        String propertyKey = values[0];
        return propertyKey;
    }
}

