/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.domain;

import io.mantisrx.server.core.domain.ArtifactID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class JobArtifact {
    @JsonProperty(value="artifactID")
    private final ArtifactID artifactID;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="createdAt")
    private final Instant createdAt;
    @JsonProperty(value="runtimeType")
    private final String runtimeType;
    @JsonProperty(value="dependencies")
    private final Map<String, String> dependencies;
    @JsonProperty(value="entrypoint")
    private final String entrypoint;
    @JsonProperty(value="tags")
    private final Map<String, String> tags;

    @ConstructorProperties(value={"artifactID", "name", "version", "createdAt", "runtimeType", "dependencies", "entrypoint", "tags"})
    JobArtifact(ArtifactID artifactID, String name, String version, Instant createdAt, String runtimeType, Map<String, String> dependencies, String entrypoint, Map<String, String> tags) {
        this.artifactID = artifactID;
        this.name = name;
        this.version = version;
        this.createdAt = createdAt;
        this.runtimeType = runtimeType;
        this.dependencies = dependencies;
        this.entrypoint = entrypoint;
        this.tags = tags;
    }

    public static JobArtifactBuilder builder() {
        return new JobArtifactBuilder();
    }

    public ArtifactID getArtifactID() {
        return this.artifactID;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public String getRuntimeType() {
        return this.runtimeType;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public String getEntrypoint() {
        return this.entrypoint;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobArtifact)) {
            return false;
        }
        JobArtifact other = (JobArtifact)o;
        ArtifactID this$artifactID = this.getArtifactID();
        ArtifactID other$artifactID = other.getArtifactID();
        if (this$artifactID == null ? other$artifactID != null : !((Object)this$artifactID).equals(other$artifactID)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$runtimeType = this.getRuntimeType();
        String other$runtimeType = other.getRuntimeType();
        if (this$runtimeType == null ? other$runtimeType != null : !this$runtimeType.equals(other$runtimeType)) {
            return false;
        }
        Map<String, String> this$dependencies = this.getDependencies();
        Map<String, String> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        String this$entrypoint = this.getEntrypoint();
        String other$entrypoint = other.getEntrypoint();
        if (this$entrypoint == null ? other$entrypoint != null : !this$entrypoint.equals(other$entrypoint)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArtifactID $artifactID = this.getArtifactID();
        result = result * 59 + ($artifactID == null ? 43 : ((Object)$artifactID).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $runtimeType = this.getRuntimeType();
        result = result * 59 + ($runtimeType == null ? 43 : $runtimeType.hashCode());
        Map<String, String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        String $entrypoint = this.getEntrypoint();
        result = result * 59 + ($entrypoint == null ? 43 : $entrypoint.hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "JobArtifact(artifactID=" + this.getArtifactID() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", createdAt=" + this.getCreatedAt() + ", runtimeType=" + this.getRuntimeType() + ", dependencies=" + this.getDependencies() + ", entrypoint=" + this.getEntrypoint() + ", tags=" + this.getTags() + ")";
    }

    public static class JobArtifactBuilder {
        private ArtifactID artifactID;
        private String name;
        private String version;
        private Instant createdAt;
        private String runtimeType;
        private Map<String, String> dependencies;
        private String entrypoint;
        private Map<String, String> tags;

        JobArtifactBuilder() {
        }

        public JobArtifactBuilder artifactID(ArtifactID artifactID) {
            this.artifactID = artifactID;
            return this;
        }

        public JobArtifactBuilder name(String name) {
            this.name = name;
            return this;
        }

        public JobArtifactBuilder version(String version) {
            this.version = version;
            return this;
        }

        public JobArtifactBuilder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public JobArtifactBuilder runtimeType(String runtimeType) {
            this.runtimeType = runtimeType;
            return this;
        }

        public JobArtifactBuilder dependencies(Map<String, String> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public JobArtifactBuilder entrypoint(String entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        public JobArtifactBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public JobArtifact build() {
            return new JobArtifact(this.artifactID, this.name, this.version, this.createdAt, this.runtimeType, this.dependencies, this.entrypoint, this.tags);
        }

        public String toString() {
            return "JobArtifact.JobArtifactBuilder(artifactID=" + this.artifactID + ", name=" + this.name + ", version=" + this.version + ", createdAt=" + this.createdAt + ", runtimeType=" + this.runtimeType + ", dependencies=" + this.dependencies + ", entrypoint=" + this.entrypoint + ", tags=" + this.tags + ")";
        }
    }
}

