/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.resourcecluster;

import io.mantisrx.common.WorkerConstants;
import io.mantisrx.common.WorkerPorts;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class TaskExecutorRegistration {
    @NonNull
    private final TaskExecutorID taskExecutorID;
    @NonNull
    private final ClusterID clusterID;
    @NonNull
    private final String taskExecutorAddress;
    @NonNull
    private final String hostname;
    @NonNull
    private final WorkerPorts workerPorts;
    @NonNull
    private final MachineDefinition machineDefinition;
    private final Map<String, String> taskExecutorAttributes;

    @JsonCreator
    public TaskExecutorRegistration(@JsonProperty(value="taskExecutorID") TaskExecutorID taskExecutorID, @JsonProperty(value="clusterID") ClusterID clusterID, @JsonProperty(value="taskExecutorAddress") String taskExecutorAddress, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="workerPorts") WorkerPorts workerPorts, @JsonProperty(value="machineDefinition") MachineDefinition machineDefinition, @JsonProperty(value="taskExecutorAttributes") Map<String, String> taskExecutorAttributes) {
        this.taskExecutorID = taskExecutorID;
        this.clusterID = clusterID;
        this.taskExecutorAddress = taskExecutorAddress;
        this.hostname = hostname;
        this.workerPorts = workerPorts;
        this.machineDefinition = machineDefinition;
        this.taskExecutorAttributes = taskExecutorAttributes == null ? ImmutableMap.of() : taskExecutorAttributes;
    }

    public boolean containsAttributes(Map<String, String> requiredAttributes) {
        for (Map.Entry<String, String> kv : requiredAttributes.entrySet()) {
            String k = kv.getKey().toLowerCase();
            if (this.taskExecutorAttributes.containsKey(k) && this.taskExecutorAttributes.get(k).equalsIgnoreCase(kv.getValue()) || this.taskExecutorAttributes.containsKey(kv.getKey()) && this.taskExecutorAttributes.get(kv.getKey()).equalsIgnoreCase(kv.getValue())) continue;
            return false;
        }
        return true;
    }

    @JsonIgnore
    public Optional<ContainerSkuID> getTaskExecutorContainerDefinitionId() {
        String containerDefIdLower = "MANTIS_WORKER_CONTAINER_DEFINITION_ID".toLowerCase();
        if (this.taskExecutorAttributes.containsKey(containerDefIdLower)) {
            return Optional.ofNullable(ContainerSkuID.of(this.getTaskExecutorAttributes().get(containerDefIdLower)));
        }
        if (this.taskExecutorAttributes.containsKey("MANTIS_WORKER_CONTAINER_DEFINITION_ID")) {
            return Optional.ofNullable(ContainerSkuID.of(this.getTaskExecutorAttributes().get("MANTIS_WORKER_CONTAINER_DEFINITION_ID")));
        }
        return Optional.empty();
    }

    @JsonIgnore
    public Optional<String> getAttributeByKey(String attributeKey) {
        if (this.taskExecutorAttributes.containsKey(attributeKey.toLowerCase())) {
            return Optional.ofNullable(this.getTaskExecutorAttributes().get(attributeKey.toLowerCase()));
        }
        if (this.taskExecutorAttributes.containsKey(attributeKey)) {
            return Optional.ofNullable(this.getTaskExecutorAttributes().get(attributeKey));
        }
        return Optional.empty();
    }

    @JsonIgnore
    public Map<String, String> getSchedulingAttributes() {
        return this.taskExecutorAttributes.entrySet().stream().flatMap(entry -> {
            Matcher matcher = WorkerConstants.MANTIS_SCHEDULING_ATTRIBUTE_PATTERN.matcher((CharSequence)entry.getKey());
            return matcher.matches() ? Stream.of(new AbstractMap.SimpleEntry(matcher.group(1).toLowerCase(), entry.getValue())) : Stream.empty();
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getAttributeByKey((String)entry.getKey()).orElse((String)entry.getValue())));
    }

    @JsonIgnore
    public TaskExecutorGroupKey getGroup() {
        Optional<String> sizeName = this.getAttributeByKey("MANTIS_WORKER_CONTAINER_SIZE_NAME").filter(name -> !name.matches("\\$\\{.*\\}"));
        return new TaskExecutorGroupKey(this.machineDefinition, sizeName, this.getSchedulingAttributes());
    }

    public static TaskExecutorRegistrationBuilder builder() {
        return new TaskExecutorRegistrationBuilder();
    }

    @NonNull
    public TaskExecutorID getTaskExecutorID() {
        return this.taskExecutorID;
    }

    @NonNull
    public ClusterID getClusterID() {
        return this.clusterID;
    }

    @NonNull
    public String getTaskExecutorAddress() {
        return this.taskExecutorAddress;
    }

    @NonNull
    public String getHostname() {
        return this.hostname;
    }

    @NonNull
    public WorkerPorts getWorkerPorts() {
        return this.workerPorts;
    }

    @NonNull
    public MachineDefinition getMachineDefinition() {
        return this.machineDefinition;
    }

    public Map<String, String> getTaskExecutorAttributes() {
        return this.taskExecutorAttributes;
    }

    public String toString() {
        return "TaskExecutorRegistration(taskExecutorID=" + this.getTaskExecutorID() + ", clusterID=" + this.getClusterID() + ", taskExecutorAddress=" + this.getTaskExecutorAddress() + ", hostname=" + this.getHostname() + ", workerPorts=" + this.getWorkerPorts() + ", machineDefinition=" + this.getMachineDefinition() + ", taskExecutorAttributes=" + this.getTaskExecutorAttributes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskExecutorRegistration)) {
            return false;
        }
        TaskExecutorRegistration other = (TaskExecutorRegistration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
        TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
        if (this$taskExecutorID == null ? other$taskExecutorID != null : !((Object)this$taskExecutorID).equals(other$taskExecutorID)) {
            return false;
        }
        ClusterID this$clusterID = this.getClusterID();
        ClusterID other$clusterID = other.getClusterID();
        if (this$clusterID == null ? other$clusterID != null : !((Object)this$clusterID).equals(other$clusterID)) {
            return false;
        }
        String this$taskExecutorAddress = this.getTaskExecutorAddress();
        String other$taskExecutorAddress = other.getTaskExecutorAddress();
        if (this$taskExecutorAddress == null ? other$taskExecutorAddress != null : !this$taskExecutorAddress.equals(other$taskExecutorAddress)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        WorkerPorts this$workerPorts = this.getWorkerPorts();
        WorkerPorts other$workerPorts = other.getWorkerPorts();
        if (this$workerPorts == null ? other$workerPorts != null : !this$workerPorts.equals(other$workerPorts)) {
            return false;
        }
        MachineDefinition this$machineDefinition = this.getMachineDefinition();
        MachineDefinition other$machineDefinition = other.getMachineDefinition();
        if (this$machineDefinition == null ? other$machineDefinition != null : !this$machineDefinition.equals(other$machineDefinition)) {
            return false;
        }
        Map<String, String> this$taskExecutorAttributes = this.getTaskExecutorAttributes();
        Map<String, String> other$taskExecutorAttributes = other.getTaskExecutorAttributes();
        return !(this$taskExecutorAttributes == null ? other$taskExecutorAttributes != null : !((Object)this$taskExecutorAttributes).equals(other$taskExecutorAttributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskExecutorRegistration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
        result = result * 59 + ($taskExecutorID == null ? 43 : ((Object)$taskExecutorID).hashCode());
        ClusterID $clusterID = this.getClusterID();
        result = result * 59 + ($clusterID == null ? 43 : ((Object)$clusterID).hashCode());
        String $taskExecutorAddress = this.getTaskExecutorAddress();
        result = result * 59 + ($taskExecutorAddress == null ? 43 : $taskExecutorAddress.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        WorkerPorts $workerPorts = this.getWorkerPorts();
        result = result * 59 + ($workerPorts == null ? 43 : $workerPorts.hashCode());
        MachineDefinition $machineDefinition = this.getMachineDefinition();
        result = result * 59 + ($machineDefinition == null ? 43 : $machineDefinition.hashCode());
        Map<String, String> $taskExecutorAttributes = this.getTaskExecutorAttributes();
        result = result * 59 + ($taskExecutorAttributes == null ? 43 : ((Object)$taskExecutorAttributes).hashCode());
        return result;
    }

    public static class TaskExecutorRegistrationBuilder {
        private TaskExecutorID taskExecutorID;
        private ClusterID clusterID;
        private String taskExecutorAddress;
        private String hostname;
        private WorkerPorts workerPorts;
        private MachineDefinition machineDefinition;
        private Map<String, String> taskExecutorAttributes;

        TaskExecutorRegistrationBuilder() {
        }

        public TaskExecutorRegistrationBuilder taskExecutorID(@NonNull TaskExecutorID taskExecutorID) {
            if (taskExecutorID == null) {
                throw new NullPointerException("taskExecutorID is marked non-null but is null");
            }
            this.taskExecutorID = taskExecutorID;
            return this;
        }

        public TaskExecutorRegistrationBuilder clusterID(@NonNull ClusterID clusterID) {
            if (clusterID == null) {
                throw new NullPointerException("clusterID is marked non-null but is null");
            }
            this.clusterID = clusterID;
            return this;
        }

        public TaskExecutorRegistrationBuilder taskExecutorAddress(@NonNull String taskExecutorAddress) {
            if (taskExecutorAddress == null) {
                throw new NullPointerException("taskExecutorAddress is marked non-null but is null");
            }
            this.taskExecutorAddress = taskExecutorAddress;
            return this;
        }

        public TaskExecutorRegistrationBuilder hostname(@NonNull String hostname) {
            if (hostname == null) {
                throw new NullPointerException("hostname is marked non-null but is null");
            }
            this.hostname = hostname;
            return this;
        }

        public TaskExecutorRegistrationBuilder workerPorts(@NonNull WorkerPorts workerPorts) {
            if (workerPorts == null) {
                throw new NullPointerException("workerPorts is marked non-null but is null");
            }
            this.workerPorts = workerPorts;
            return this;
        }

        public TaskExecutorRegistrationBuilder machineDefinition(@NonNull MachineDefinition machineDefinition) {
            if (machineDefinition == null) {
                throw new NullPointerException("machineDefinition is marked non-null but is null");
            }
            this.machineDefinition = machineDefinition;
            return this;
        }

        public TaskExecutorRegistrationBuilder taskExecutorAttributes(Map<String, String> taskExecutorAttributes) {
            this.taskExecutorAttributes = taskExecutorAttributes;
            return this;
        }

        public TaskExecutorRegistration build() {
            return new TaskExecutorRegistration(this.taskExecutorID, this.clusterID, this.taskExecutorAddress, this.hostname, this.workerPorts, this.machineDefinition, this.taskExecutorAttributes);
        }

        public String toString() {
            return "TaskExecutorRegistration.TaskExecutorRegistrationBuilder(taskExecutorID=" + this.taskExecutorID + ", clusterID=" + this.clusterID + ", taskExecutorAddress=" + this.taskExecutorAddress + ", hostname=" + this.hostname + ", workerPorts=" + this.workerPorts + ", machineDefinition=" + this.machineDefinition + ", taskExecutorAttributes=" + this.taskExecutorAttributes + ")";
        }
    }

    public static final class TaskExecutorGroupKey {
        private final MachineDefinition machineDefinition;
        private final Optional<String> sizeName;
        private final Map<String, String> schedulingAttributes;

        public TaskExecutorGroupKey(MachineDefinition machineDefinition, Optional<String> sizeName, Map<String, String> schedulingAttributes) {
            this.machineDefinition = new MachineDefinition((double)Math.round(machineDefinition.getCpuCores()), (double)Math.round(machineDefinition.getMemoryMB()), (double)Math.round(machineDefinition.getNetworkMbps()), (double)Math.round(machineDefinition.getDiskMB()), machineDefinition.getNumPorts());
            this.sizeName = sizeName;
            this.schedulingAttributes = schedulingAttributes;
        }

        public MachineDefinition getMachineDefinition() {
            return this.machineDefinition;
        }

        public Optional<String> getSizeName() {
            return this.sizeName;
        }

        public Map<String, String> getSchedulingAttributes() {
            return this.schedulingAttributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorGroupKey)) {
                return false;
            }
            TaskExecutorGroupKey other = (TaskExecutorGroupKey)o;
            MachineDefinition this$machineDefinition = this.getMachineDefinition();
            MachineDefinition other$machineDefinition = other.getMachineDefinition();
            if (this$machineDefinition == null ? other$machineDefinition != null : !this$machineDefinition.equals(other$machineDefinition)) {
                return false;
            }
            Optional<String> this$sizeName = this.getSizeName();
            Optional<String> other$sizeName = other.getSizeName();
            if (this$sizeName == null ? other$sizeName != null : !((Object)this$sizeName).equals(other$sizeName)) {
                return false;
            }
            Map<String, String> this$schedulingAttributes = this.getSchedulingAttributes();
            Map<String, String> other$schedulingAttributes = other.getSchedulingAttributes();
            return !(this$schedulingAttributes == null ? other$schedulingAttributes != null : !((Object)this$schedulingAttributes).equals(other$schedulingAttributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MachineDefinition $machineDefinition = this.getMachineDefinition();
            result = result * 59 + ($machineDefinition == null ? 43 : $machineDefinition.hashCode());
            Optional<String> $sizeName = this.getSizeName();
            result = result * 59 + ($sizeName == null ? 43 : ((Object)$sizeName).hashCode());
            Map<String, String> $schedulingAttributes = this.getSchedulingAttributes();
            result = result * 59 + ($schedulingAttributes == null ? 43 : ((Object)$schedulingAttributes).hashCode());
            return result;
        }

        public String toString() {
            return "TaskExecutorRegistration.TaskExecutorGroupKey(machineDefinition=" + this.getMachineDefinition() + ", sizeName=" + this.getSizeName() + ", schedulingAttributes=" + this.getSchedulingAttributes() + ")";
        }
    }
}

