/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.common.WorkerPorts;
import io.mantisrx.runtime.MantisJobDurationType;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteStageRequest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ExecuteStageRequest.class);
    public static final long DEFAULT_HEARTBEAT_INTERVAL_SECS = 20L;
    private static final long serialVersionUID = 1L;
    private final boolean hasJobMaster;
    private final long heartbeatIntervalSecs;
    private final long subscriptionTimeoutSecs;
    private final long minRuntimeSecs;
    private final WorkerPorts workerPorts;
    private final String jobName;
    private final String jobId;
    private final int workerIndex;
    private final int workerNumber;
    private final URL jobJarUrl;
    private final int stage;
    private final int totalNumStages;
    private final int metricsPort;
    private final List<Integer> ports = new ArrayList<Integer>();
    private final long timeoutToReportStart;
    private final List<Parameter> parameters;
    private final SchedulingInfo schedulingInfo;
    private final MantisJobDurationType durationType;
    @Nullable
    private final String nameOfJobProviderClass;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public ExecuteStageRequest(@JsonProperty(value="jobName") String jobName, @JsonProperty(value="jobID") String jobId, @JsonProperty(value="workerIndex") int workerIndex, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="jobJarUrl") URL jobJarUrl, @JsonProperty(value="stage") int stage, @JsonProperty(value="totalNumStages") int totalNumStages, @JsonProperty(value="ports") List<Integer> ports, @JsonProperty(value="timeoutToReportStart") long timeoutToReportStart, @JsonProperty(value="metricsPort") int metricsPort, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="schedulingInfo") SchedulingInfo schedulingInfo, @JsonProperty(value="durationType") MantisJobDurationType durationType, @JsonProperty(value="heartbeatIntervalSecs") long heartbeatIntervalSecs, @JsonProperty(value="subscriptionTimeoutSecs") long subscriptionTimeoutSecs, @JsonProperty(value="minRuntimeSecs") long minRuntimeSecs, @JsonProperty(value="workerPorts") WorkerPorts workerPorts, @JsonProperty(value="nameOfJobProviderClass") Optional<String> nameOfJobProviderClass) {
        this.jobName = jobName;
        this.jobId = jobId;
        this.workerIndex = workerIndex;
        this.workerNumber = workerNumber;
        this.jobJarUrl = jobJarUrl;
        this.stage = stage;
        this.totalNumStages = totalNumStages;
        this.nameOfJobProviderClass = nameOfJobProviderClass.orElse(null);
        this.ports.addAll(ports);
        this.metricsPort = metricsPort;
        this.timeoutToReportStart = timeoutToReportStart;
        this.parameters = parameters != null ? parameters : new LinkedList<Parameter>();
        this.schedulingInfo = schedulingInfo;
        this.durationType = durationType;
        this.heartbeatIntervalSecs = heartbeatIntervalSecs > 0L ? heartbeatIntervalSecs : 20L;
        log.info("heartbeat interval {}, using {}", (Object)heartbeatIntervalSecs, (Object)this.heartbeatIntervalSecs);
        this.hasJobMaster = schedulingInfo != null && schedulingInfo.forStage(0) != null;
        this.subscriptionTimeoutSecs = subscriptionTimeoutSecs;
        this.minRuntimeSecs = minRuntimeSecs;
        this.workerPorts = workerPorts;
    }

    public boolean getHasJobMaster() {
        return this.hasJobMaster;
    }

    public Optional<String> getNameOfJobProviderClass() {
        return Optional.ofNullable(this.nameOfJobProviderClass);
    }

    public WorkerId getWorkerId() {
        return new WorkerId(this.jobId, this.workerIndex, this.workerNumber);
    }

    public long getHeartbeatIntervalSecs() {
        return this.heartbeatIntervalSecs;
    }

    public long getSubscriptionTimeoutSecs() {
        return this.subscriptionTimeoutSecs;
    }

    public long getMinRuntimeSecs() {
        return this.minRuntimeSecs;
    }

    public WorkerPorts getWorkerPorts() {
        return this.workerPorts;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public int getWorkerNumber() {
        return this.workerNumber;
    }

    public URL getJobJarUrl() {
        return this.jobJarUrl;
    }

    public int getStage() {
        return this.stage;
    }

    public int getTotalNumStages() {
        return this.totalNumStages;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public long getTimeoutToReportStart() {
        return this.timeoutToReportStart;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public SchedulingInfo getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public MantisJobDurationType getDurationType() {
        return this.durationType;
    }

    public String toString() {
        return "ExecuteStageRequest(hasJobMaster=" + this.getHasJobMaster() + ", heartbeatIntervalSecs=" + this.getHeartbeatIntervalSecs() + ", subscriptionTimeoutSecs=" + this.getSubscriptionTimeoutSecs() + ", minRuntimeSecs=" + this.getMinRuntimeSecs() + ", workerPorts=" + this.getWorkerPorts() + ", jobName=" + this.getJobName() + ", jobId=" + this.getJobId() + ", workerIndex=" + this.getWorkerIndex() + ", workerNumber=" + this.getWorkerNumber() + ", jobJarUrl=" + this.getJobJarUrl() + ", stage=" + this.getStage() + ", totalNumStages=" + this.getTotalNumStages() + ", metricsPort=" + this.getMetricsPort() + ", ports=" + this.getPorts() + ", timeoutToReportStart=" + this.getTimeoutToReportStart() + ", parameters=" + this.getParameters() + ", schedulingInfo=" + this.getSchedulingInfo() + ", durationType=" + this.getDurationType() + ", nameOfJobProviderClass=" + this.getNameOfJobProviderClass() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecuteStageRequest)) {
            return false;
        }
        ExecuteStageRequest other = (ExecuteStageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHasJobMaster() != other.getHasJobMaster()) {
            return false;
        }
        if (this.getHeartbeatIntervalSecs() != other.getHeartbeatIntervalSecs()) {
            return false;
        }
        if (this.getSubscriptionTimeoutSecs() != other.getSubscriptionTimeoutSecs()) {
            return false;
        }
        if (this.getMinRuntimeSecs() != other.getMinRuntimeSecs()) {
            return false;
        }
        if (this.getWorkerIndex() != other.getWorkerIndex()) {
            return false;
        }
        if (this.getWorkerNumber() != other.getWorkerNumber()) {
            return false;
        }
        if (this.getStage() != other.getStage()) {
            return false;
        }
        if (this.getTotalNumStages() != other.getTotalNumStages()) {
            return false;
        }
        if (this.getMetricsPort() != other.getMetricsPort()) {
            return false;
        }
        if (this.getTimeoutToReportStart() != other.getTimeoutToReportStart()) {
            return false;
        }
        WorkerPorts this$workerPorts = this.getWorkerPorts();
        WorkerPorts other$workerPorts = other.getWorkerPorts();
        if (this$workerPorts == null ? other$workerPorts != null : !this$workerPorts.equals(other$workerPorts)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        URL this$jobJarUrl = this.getJobJarUrl();
        URL other$jobJarUrl = other.getJobJarUrl();
        if (this$jobJarUrl == null ? other$jobJarUrl != null : !((Object)this$jobJarUrl).equals(other$jobJarUrl)) {
            return false;
        }
        List<Integer> this$ports = this.getPorts();
        List<Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        SchedulingInfo this$schedulingInfo = this.getSchedulingInfo();
        SchedulingInfo other$schedulingInfo = other.getSchedulingInfo();
        if (this$schedulingInfo == null ? other$schedulingInfo != null : !this$schedulingInfo.equals(other$schedulingInfo)) {
            return false;
        }
        MantisJobDurationType this$durationType = this.getDurationType();
        MantisJobDurationType other$durationType = other.getDurationType();
        if (this$durationType == null ? other$durationType != null : !this$durationType.equals(other$durationType)) {
            return false;
        }
        Optional<String> this$nameOfJobProviderClass = this.getNameOfJobProviderClass();
        Optional<String> other$nameOfJobProviderClass = other.getNameOfJobProviderClass();
        return !(this$nameOfJobProviderClass == null ? other$nameOfJobProviderClass != null : !((Object)this$nameOfJobProviderClass).equals(other$nameOfJobProviderClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecuteStageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getHasJobMaster() ? 79 : 97);
        long $heartbeatIntervalSecs = this.getHeartbeatIntervalSecs();
        result = result * 59 + (int)($heartbeatIntervalSecs >>> 32 ^ $heartbeatIntervalSecs);
        long $subscriptionTimeoutSecs = this.getSubscriptionTimeoutSecs();
        result = result * 59 + (int)($subscriptionTimeoutSecs >>> 32 ^ $subscriptionTimeoutSecs);
        long $minRuntimeSecs = this.getMinRuntimeSecs();
        result = result * 59 + (int)($minRuntimeSecs >>> 32 ^ $minRuntimeSecs);
        result = result * 59 + this.getWorkerIndex();
        result = result * 59 + this.getWorkerNumber();
        result = result * 59 + this.getStage();
        result = result * 59 + this.getTotalNumStages();
        result = result * 59 + this.getMetricsPort();
        long $timeoutToReportStart = this.getTimeoutToReportStart();
        result = result * 59 + (int)($timeoutToReportStart >>> 32 ^ $timeoutToReportStart);
        WorkerPorts $workerPorts = this.getWorkerPorts();
        result = result * 59 + ($workerPorts == null ? 43 : $workerPorts.hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        URL $jobJarUrl = this.getJobJarUrl();
        result = result * 59 + ($jobJarUrl == null ? 43 : ((Object)$jobJarUrl).hashCode());
        List<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        SchedulingInfo $schedulingInfo = this.getSchedulingInfo();
        result = result * 59 + ($schedulingInfo == null ? 43 : $schedulingInfo.hashCode());
        MantisJobDurationType $durationType = this.getDurationType();
        result = result * 59 + ($durationType == null ? 43 : $durationType.hashCode());
        Optional<String> $nameOfJobProviderClass = this.getNameOfJobProviderClass();
        result = result * 59 + ($nameOfJobProviderClass == null ? 43 : ((Object)$nameOfJobProviderClass).hashCode());
        return result;
    }
}

