/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.master;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class MasterDescription {
    public static final String JSON_PROP_HOSTNAME = "hostname";
    public static final String JSON_PROP_HOST_IP = "hostIP";
    public static final String JSON_PROP_API_PORT = "apiPort";
    public static final String JSON_PROP_SCHED_INFO_PORT = "schedInfoPort";
    public static final String JSON_PROP_API_PORT_V2 = "apiPortV2";
    public static final String JSON_PROP_API_STATUS_URI = "apiStatusUri";
    public static final String JSON_PROP_CONSOLE_PORT = "consolePort";
    public static final String JSON_PROP_CREATE_TIME = "createTime";
    private final String hostname;
    private final String hostIP;
    private final int apiPort;
    private final int schedInfoPort;
    private final int apiPortV2;
    private final String apiStatusUri;
    private final long createTime;
    private final int consolePort;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MasterDescription(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="hostIP") String hostIP, @JsonProperty(value="apiPort") int apiPort, @JsonProperty(value="schedInfoPort") int schedInfoPort, @JsonProperty(value="apiPortV2") int apiPortV2, @JsonProperty(value="apiStatusUri") String apiStatusUri, @JsonProperty(value="consolePort") int consolePort, @JsonProperty(value="createTime") long createTime) {
        this.hostname = hostname;
        this.hostIP = hostIP;
        this.apiPort = apiPort;
        this.schedInfoPort = schedInfoPort;
        this.apiPortV2 = apiPortV2;
        this.apiStatusUri = apiStatusUri;
        this.consolePort = consolePort;
        this.createTime = createTime;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostIP")
    public String getHostIP() {
        return this.hostIP;
    }

    @JsonProperty(value="apiPort")
    public int getApiPort() {
        return this.apiPort;
    }

    @JsonProperty(value="schedInfoPort")
    public int getSchedInfoPort() {
        return this.schedInfoPort;
    }

    @JsonProperty(value="apiPortV2")
    public int getApiPortV2() {
        return this.apiPortV2;
    }

    @JsonProperty(value="apiStatusUri")
    public String getApiStatusUri() {
        return this.apiStatusUri;
    }

    @JsonProperty(value="createTime")
    public long getCreateTime() {
        return this.createTime;
    }

    public String getFullApiStatusUri() {
        String uri = this.getApiStatusUri().trim();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return String.format("http://%s:%d/%s", this.getHostname(), this.getApiPort(), uri);
    }

    @JsonProperty(value="consolePort")
    public int getConsolePort() {
        return this.consolePort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterDescription)) {
            return false;
        }
        MasterDescription other = (MasterDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getApiPort() != other.getApiPort()) {
            return false;
        }
        if (this.getSchedInfoPort() != other.getSchedInfoPort()) {
            return false;
        }
        if (this.getApiPortV2() != other.getApiPortV2()) {
            return false;
        }
        if (this.getCreateTime() != other.getCreateTime()) {
            return false;
        }
        if (this.getConsolePort() != other.getConsolePort()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$hostIP = this.getHostIP();
        String other$hostIP = other.getHostIP();
        if (this$hostIP == null ? other$hostIP != null : !this$hostIP.equals(other$hostIP)) {
            return false;
        }
        String this$apiStatusUri = this.getApiStatusUri();
        String other$apiStatusUri = other.getApiStatusUri();
        return !(this$apiStatusUri == null ? other$apiStatusUri != null : !this$apiStatusUri.equals(other$apiStatusUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MasterDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getApiPort();
        result = result * 59 + this.getSchedInfoPort();
        result = result * 59 + this.getApiPortV2();
        long $createTime = this.getCreateTime();
        result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
        result = result * 59 + this.getConsolePort();
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $hostIP = this.getHostIP();
        result = result * 59 + ($hostIP == null ? 43 : $hostIP.hashCode());
        String $apiStatusUri = this.getApiStatusUri();
        result = result * 59 + ($apiStatusUri == null ? 43 : $apiStatusUri.hashCode());
        return result;
    }

    public String toString() {
        return "MasterDescription(hostname=" + this.getHostname() + ", hostIP=" + this.getHostIP() + ", apiPort=" + this.getApiPort() + ", schedInfoPort=" + this.getSchedInfoPort() + ", apiPortV2=" + this.getApiPortV2() + ", apiStatusUri=" + this.getApiStatusUri() + ", createTime=" + this.getCreateTime() + ", consolePort=" + this.getConsolePort() + ")";
    }
}

