/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.master;

import io.mantisrx.common.JsonSerializer;
import io.mantisrx.server.core.json.DefaultObjectMapper;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractIdleService;
import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.api.BackgroundCallback;
import io.mantisrx.shaded.org.apache.curator.framework.api.CuratorEvent;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.NodeCache;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.cache.NodeCacheListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.BehaviorSubject;

public class ZookeeperMasterMonitor
extends AbstractIdleService
implements MasterMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperMasterMonitor.class);
    private final CuratorFramework curator;
    private final String masterPath;
    private final BehaviorSubject<MasterDescription> masterSubject;
    private final AtomicReference<MasterDescription> latestMaster = new AtomicReference();
    private final NodeCache nodeMonitor;
    private final JsonSerializer jsonSerializer;

    public ZookeeperMasterMonitor(CuratorFramework curator, String masterPath) {
        this.curator = curator;
        this.masterPath = masterPath;
        this.masterSubject = BehaviorSubject.create();
        this.nodeMonitor = new NodeCache(curator, masterPath);
        this.jsonSerializer = new JsonSerializer();
    }

    public void startUp() throws Exception {
        this.nodeMonitor.getListenable().addListener((Object)new NodeCacheListener(){

            public void nodeChanged() throws Exception {
                ZookeeperMasterMonitor.this.retrieveMaster();
            }
        });
        this.nodeMonitor.start(true);
        this.onMasterNodeUpdated(this.nodeMonitor.getCurrentData() == null ? null : this.nodeMonitor.getCurrentData().getData());
        logger.info("The ZK master monitor has started");
    }

    private void onMasterNodeUpdated(@Nullable byte[] data) throws Exception {
        if (data != null) {
            logger.info("value was {}", (Object)new String(data));
            MasterDescription description = (MasterDescription)DefaultObjectMapper.getInstance().readValue(data, MasterDescription.class);
            logger.info("new master description = {}", (Object)description);
            this.latestMaster.set(description);
            this.masterSubject.onNext((Object)description);
        } else {
            logger.info("looks like there's no master at the moment");
        }
    }

    private void retrieveMaster() {
        try {
            ((ErrorListenerPathable)this.curator.sync().inBackground(((ErrorListenerPathable)this.curator.getData().inBackground(new BackgroundCallback(){

                public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                    ZookeeperMasterMonitor.this.onMasterNodeUpdated(event.getData());
                }
            })).forPath(this.masterPath))).forPath(this.masterPath);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve updated master information: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Observable<MasterDescription> getMasterObservable() {
        return this.masterSubject;
    }

    @Override
    @Nullable
    public MasterDescription getLatestMaster() {
        Preconditions.checkState((boolean)this.isRunning(), (String)"ZookeeperMasterMonitor is currently not running but instead is at state %s", (Object)this.state());
        return this.latestMaster.get();
    }

    public void shutDown() throws Exception {
        this.nodeMonitor.close();
        logger.info("ZK master monitor is shut down");
    }
}

