/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.server.core.Service;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;

public abstract class BaseService
implements Service {
    private static AtomicInteger SERVICES_COUNTER = new AtomicInteger(0);
    private final boolean awaitsActiveMode;
    private final ActiveMode activeMode = new ActiveMode();
    private final int myServiceCount;
    private BaseService predecessor = null;

    protected BaseService() {
        this(false);
    }

    protected BaseService(boolean awaitsActiveMode) {
        this.awaitsActiveMode = awaitsActiveMode;
        if (!this.awaitsActiveMode) {
            this.activeMode.isInited.set(true);
        }
        this.myServiceCount = SERVICES_COUNTER.getAndIncrement();
    }

    @Override
    public abstract void start();

    protected void awaitActiveModeAndStart(Action0 onActive) {
        this.activeMode.waitAndStart(onActive, this.predecessor);
    }

    protected boolean getIsInited() {
        return this.activeMode.getIsInited() && (this.predecessor == null || this.predecessor.getIsInited());
    }

    @Override
    public void enterActiveMode() {
        this.activeMode.enterActiveMode();
    }

    @Override
    public void shutdown() {
    }

    public void addPredecessor(BaseService service) {
        this.predecessor = service;
    }

    public int getMyServiceCount() {
        return this.myServiceCount;
    }

    public static BaseService wrap(final io.mantisrx.shaded.com.google.common.util.concurrent.Service service) {
        return new BaseService(){

            @Override
            public void start() {
            }

            @Override
            public void enterActiveMode() {
                service.startAsync().awaitRunning();
                super.enterActiveMode();
            }

            @Override
            public void shutdown() {
                service.stopAsync().awaitTerminated();
                super.shutdown();
            }
        };
    }

    public class ActiveMode {
        private final AtomicBoolean isLeaderMode = new AtomicBoolean(false);
        private final AtomicBoolean isInited = new AtomicBoolean(false);
        Logger logger = LoggerFactory.getLogger(ActiveMode.class);

        public boolean getIsInited() {
            return this.isInited.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitLeaderMode() {
            while (!this.isLeaderMode.get()) {
                AtomicBoolean atomicBoolean = this.isLeaderMode;
                synchronized (atomicBoolean) {
                    try {
                        this.isLeaderMode.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.info("Interrupted waiting for leaderModeLatch");
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void waitAndStart(final Action0 onActive, final BaseService predecessor) {
            this.logger.info(BaseService.this.myServiceCount + ": Setting up thread to wait for entering leader mode");
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ActiveMode.this.awaitLeaderMode();
                    ActiveMode.this.logger.info(BaseService.this.myServiceCount + ": done waiting for leader mode");
                    if (predecessor != null) {
                        predecessor.activeMode.awaitInit();
                    }
                    ActiveMode.this.logger.info(BaseService.this.myServiceCount + ": done waiting for predecessor init");
                    if (onActive != null) {
                        onActive.call();
                    }
                    AtomicBoolean atomicBoolean = ActiveMode.this.isInited;
                    synchronized (atomicBoolean) {
                        ActiveMode.this.isInited.set(true);
                        ActiveMode.this.isInited.notify();
                    }
                }
            };
            Thread thr = new Thread(runnable, "BaseService-LeaderModeWaitThread-" + BaseService.this.myServiceCount);
            thr.setDaemon(true);
            thr.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitInit() {
            while (!this.isInited.get()) {
                AtomicBoolean atomicBoolean = this.isInited;
                synchronized (atomicBoolean) {
                    try {
                        this.isInited.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.info("Interrupted waiting for predecessor init");
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (BaseService.this.predecessor != null) {
                BaseService.this.predecessor.activeMode.awaitInit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterActiveMode() {
            this.logger.info(BaseService.this.myServiceCount + ": Entering leader mode");
            AtomicBoolean atomicBoolean = this.isLeaderMode;
            synchronized (atomicBoolean) {
                this.isLeaderMode.set(true);
                this.isLeaderMode.notify();
            }
        }
    }
}

