/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.zookeeper;

import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.server.core.BaseService;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.core.master.ZookeeperMasterMonitor;
import io.mantisrx.shaded.com.google.common.util.concurrent.MoreExecutors;
import io.mantisrx.shaded.org.apache.curator.RetryPolicy;
import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.CuratorFrameworkFactory;
import io.mantisrx.shaded.org.apache.curator.framework.api.CompressionProvider;
import io.mantisrx.shaded.org.apache.curator.framework.imps.GzipCompressionProvider;
import io.mantisrx.shaded.org.apache.curator.framework.state.ConnectionState;
import io.mantisrx.shaded.org.apache.curator.framework.state.ConnectionStateListener;
import io.mantisrx.shaded.org.apache.curator.retry.ExponentialBackoffRetry;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorService.class);
    private static final String isConnectedGaugeName = "isConnected";
    private final CuratorFramework curator;
    private final ZookeeperMasterMonitor masterMonitor;
    private final Gauge isConnectedGauge;

    public CuratorService(CoreConfiguration configs) {
        super(false);
        Metrics m = new Metrics.Builder().name(CuratorService.class.getCanonicalName()).addGauge(isConnectedGaugeName).build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.isConnectedGauge = m.getGauge(isConnectedGaugeName);
        this.curator = CuratorFrameworkFactory.builder().compressionProvider((CompressionProvider)new GzipCompressionProvider()).connectionTimeoutMs(configs.getZkConnectionTimeoutMs()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(configs.getZkConnectionRetrySleepMs(), configs.getZkConnectionMaxRetries())).connectString(configs.getZkConnectionString()).build();
        this.masterMonitor = new ZookeeperMasterMonitor(this.curator, ZKPaths.makePath((String)configs.getZkRoot(), (String)configs.getLeaderAnnouncementPath()));
    }

    private void setupCuratorListener() {
        LOG.info("Setting up curator state change listener");
        this.curator.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (newState.isConnected()) {
                    LOG.info("Curator connected");
                    CuratorService.this.isConnectedGauge.set(1L);
                } else {
                    LOG.error("Curator connection lost");
                    CuratorService.this.isConnectedGauge.set(0L);
                }
            }
        }, (Executor)MoreExecutors.newDirectExecutorService());
    }

    @Override
    public void start() {
        try {
            this.isConnectedGauge.set(0L);
            this.setupCuratorListener();
            this.curator.start();
            this.masterMonitor.startAsync().awaitRunning();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.masterMonitor.stopAsync().awaitTerminated();
            this.curator.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to shut down the curator service: " + e.getMessage(), (Throwable)e);
        }
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public MasterMonitor getMasterMonitor() {
        return this.masterMonitor;
    }
}

