/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.metrics;

import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.ExecuteStageRequest;
import io.mantisrx.server.core.metrics.MetricsPublisherService;
import io.mantisrx.server.core.metrics.MetricsServerService;
import java.util.HashMap;
import java.util.Map;

public class MetricsFactory {
    public static MetricsServerService newMetricsServer(CoreConfiguration configuration, ExecuteStageRequest request) {
        return new MetricsServerService(request.getMetricsPort(), 1, MetricsFactory.getCommonTags(request));
    }

    public static MetricsPublisherService newMetricsPublisher(CoreConfiguration config, ExecuteStageRequest request) {
        return new MetricsPublisherService(config.getMetricsPublisher(), config.getMetricsPublisherFrequencyInSeconds(), MetricsFactory.getCommonTags(request));
    }

    public static Map<String, String> getCommonTags(ExecuteStageRequest request) {
        HashMap<String, String> commonTags = new HashMap<String, String>();
        commonTags.put("mantisWorkerNum", Integer.toString(request.getWorkerNumber()));
        commonTags.put("mantisStageNum", Integer.toString(request.getStage()));
        commonTags.put("mantisWorkerIndex", Integer.toString(request.getWorkerIndex()));
        commonTags.put("mantisJobName", request.getJobName());
        commonTags.put("mantisJobId", request.getJobId());
        return commonTags;
    }
}

