/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcServer;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.akka.AkkaRpcSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class TestingRpcService
implements RpcService {
    private static final RpcSystem RPC_SYSTEM_SINGLETON = new AkkaRpcSystem();
    private static final Function<RpcGateway, CompletableFuture<RpcGateway>> DEFAULT_RPC_GATEWAY_FUTURE_FUNCTION = CompletableFuture::completedFuture;
    private final ConcurrentHashMap<String, RpcGateway> registeredConnections;
    private volatile Function<RpcGateway, CompletableFuture<RpcGateway>> rpcGatewayFutureFunction = DEFAULT_RPC_GATEWAY_FUTURE_FUNCTION;
    private final RpcService backingRpcService;

    public TestingRpcService() {
        try {
            this.backingRpcService = RPC_SYSTEM_SINGLETON.localServiceBuilder(new Configuration()).createAndStart();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.registeredConnections = new ConcurrentHashMap();
    }

    public CompletableFuture<Void> stopService() {
        CompletableFuture terminationFuture = this.backingRpcService.stopService();
        terminationFuture.whenComplete((ignored, throwable) -> this.registeredConnections.clear());
        return terminationFuture;
    }

    public void registerGateway(String address, RpcGateway gateway) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)gateway);
        if (this.registeredConnections.putIfAbsent(address, gateway) != null) {
            throw new IllegalStateException("a gateway is already registered under " + address);
        }
    }

    public void unregisterGateway(String address) {
        Preconditions.checkNotNull((Object)address);
        if (this.registeredConnections.remove(address) == null) {
            throw new IllegalStateException("no gateway is registered under " + address);
        }
    }

    private <C extends RpcGateway> CompletableFuture<C> getRpcGatewayFuture(C gateway) {
        return this.rpcGatewayFutureFunction.apply(gateway);
    }

    public <C extends RpcGateway> CompletableFuture<C> connect(String address, Class<C> clazz) {
        RpcGateway gateway = this.registeredConnections.get(address);
        if (gateway != null) {
            if (clazz.isAssignableFrom(gateway.getClass())) {
                RpcGateway typedGateway = gateway;
                return this.getRpcGatewayFuture(typedGateway);
            }
            return FutureUtils.completedExceptionally((Throwable)new Exception("Gateway registered under " + address + " is not of type " + clazz));
        }
        return this.backingRpcService.connect(address, clazz);
    }

    public <F extends Serializable, C extends FencedRpcGateway<F>> CompletableFuture<C> connect(String address, F fencingToken, Class<C> clazz) {
        RpcGateway gateway = this.registeredConnections.get(address);
        if (gateway != null) {
            if (clazz.isAssignableFrom(gateway.getClass())) {
                FencedRpcGateway typedGateway = (FencedRpcGateway)gateway;
                return this.getRpcGatewayFuture(typedGateway);
            }
            return FutureUtils.completedExceptionally((Throwable)new Exception("Gateway registered under " + address + " is not of type " + clazz));
        }
        return this.backingRpcService.connect(address, fencingToken, clazz);
    }

    public void clearGateways() {
        this.registeredConnections.clear();
    }

    public void resetRpcGatewayFutureFunction() {
        this.rpcGatewayFutureFunction = DEFAULT_RPC_GATEWAY_FUTURE_FUNCTION;
    }

    public void setRpcGatewayFutureFunction(Function<RpcGateway, CompletableFuture<RpcGateway>> rpcGatewayFutureFunction) {
        this.rpcGatewayFutureFunction = rpcGatewayFutureFunction;
    }

    public String getAddress() {
        return this.backingRpcService.getAddress();
    }

    public int getPort() {
        return this.backingRpcService.getPort();
    }

    public <C extends RpcEndpoint> RpcServer startServer(C rpcEndpoint) {
        return this.backingRpcService.startServer(rpcEndpoint);
    }

    public <F extends Serializable> RpcServer fenceRpcServer(RpcServer rpcServer, F fencingToken) {
        return this.backingRpcService.fenceRpcServer(rpcServer, fencingToken);
    }

    public void stopServer(RpcServer selfGateway) {
        this.backingRpcService.stopServer(selfGateway);
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.backingRpcService.getTerminationFuture();
    }

    public ScheduledExecutor getScheduledExecutor() {
        return this.backingRpcService.getScheduledExecutor();
    }

    public ScheduledFuture<?> scheduleRunnable(Runnable runnable, long delay, TimeUnit unit) {
        return this.backingRpcService.scheduleRunnable(runnable, delay, unit);
    }

    public void execute(Runnable runnable) {
        this.backingRpcService.execute(runnable);
    }

    public <T> CompletableFuture<T> execute(Callable<T> callable) {
        return this.backingRpcService.execute(callable);
    }
}

