/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.server.core.CleanupOnCloseRpcSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ServiceLoader;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.classloading.ComponentClassLoader;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcSystemLoader;
import org.apache.flink.util.IOUtils;

public class MantisAkkaRpcSystemLoader
implements RpcSystemLoader {
    private static final RpcSystem INSTANCE = MantisAkkaRpcSystemLoader.createRpcSystem();

    public static RpcSystem getInstance() {
        return INSTANCE;
    }

    public RpcSystem loadRpcSystem(Configuration config) {
        return INSTANCE;
    }

    private static RpcSystem createRpcSystem() {
        try {
            ClassLoader flinkClassLoader = RpcSystem.class.getClassLoader();
            Path tmpDirectory = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            Files.createDirectories(tmpDirectory, new FileAttribute[0]);
            Path tempFile = Files.createFile(tmpDirectory.resolve("flink-rpc-akka_" + UUID.randomUUID() + ".jar"), new FileAttribute[0]);
            InputStream resourceStream = flinkClassLoader.getResourceAsStream("flink-rpc-akka.jar");
            if (resourceStream == null) {
                throw new RuntimeException("Akka RPC system could not be found. If this happened while running a test in the IDE,run the process-resources phase on flink-rpc/flink-rpc-akka-loader via maven.");
            }
            IOUtils.copyBytes((InputStream)resourceStream, (OutputStream)Files.newOutputStream(tempFile, new OpenOption[0]));
            ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[]{tempFile.toUri().toURL()}, flinkClassLoader, CoreOptions.parseParentFirstLoaderPatterns((String)"org.slf4j;org.apache.log4j;org.apache.logging;org.apache.commons.logging;ch.qos.logback;io.mantisrx.server.worker;io.mantisrx.server.core;io.mantisrx", (String)""), new String[]{"org.apache.flink"});
            return new CleanupOnCloseRpcSystem(ServiceLoader.load(RpcSystem.class, (ClassLoader)componentClassLoader).iterator().next(), componentClassLoader, tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize RPC system.", e);
        }
    }
}

