/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.domain;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerId {
    private static final Logger logger = LoggerFactory.getLogger(WorkerId.class);
    private static final String DELIMITER = "-";
    private static final String WORKER_DELIMITER = "-worker-";
    private final String jobCluster;
    private final String jobId;
    private final int wIndex;
    private final int wNum;
    private final String id;

    public WorkerId(String jobId, int wIndex, int wNum) {
        this(WorkerId.getJobClusterFromId(jobId), jobId, wIndex, wNum);
    }

    public WorkerId(String jobCluster, String jobId, int wIndex, int wNum) {
        this.jobCluster = jobCluster;
        this.jobId = jobId;
        this.wIndex = wIndex;
        this.wNum = wNum;
        this.id = jobId + WORKER_DELIMITER + wIndex + '-' + wNum;
    }

    private static String getJobClusterFromId(String jobId) {
        int jobClusterIdx = jobId.lastIndexOf(DELIMITER);
        if (jobClusterIdx > 0) {
            return jobId.substring(0, jobClusterIdx);
        }
        logger.error("Failed to get JobCluster name from Job ID {}", (Object)jobId);
        throw new IllegalArgumentException("Job ID is invalid " + jobId);
    }

    public static Optional<WorkerId> fromId(String id) {
        String jobId;
        int jobClusterIdx;
        int workerDelimIndex = id.indexOf(WORKER_DELIMITER);
        if (workerDelimIndex > 0 && (jobClusterIdx = (jobId = id.substring(0, workerDelimIndex)).lastIndexOf(DELIMITER)) > 0) {
            String jobCluster = jobId.substring(0, jobClusterIdx);
            String workerInfo = id.substring(workerDelimIndex + WORKER_DELIMITER.length());
            int delimiterIndex = workerInfo.indexOf(DELIMITER);
            if (delimiterIndex > 0) {
                try {
                    int wIndex = Integer.parseInt(workerInfo.substring(0, delimiterIndex));
                    int wNum = Integer.parseInt(workerInfo.substring(delimiterIndex + 1));
                    return Optional.of(new WorkerId(jobCluster, jobId, wIndex, wNum));
                }
                catch (NumberFormatException nfe) {
                    logger.warn("failed to parse workerId from {}", (Object)id, (Object)nfe);
                }
            }
        }
        logger.warn("failed to parse workerId from {}", (Object)id);
        return Optional.empty();
    }

    public String getJobCluster() {
        return this.jobCluster;
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getWorkerIndex() {
        return this.wIndex;
    }

    public int getWorkerNum() {
        return this.wNum;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerId workerId = (WorkerId)o;
        if (this.wIndex != workerId.wIndex) {
            return false;
        }
        if (this.wNum != workerId.wNum) {
            return false;
        }
        if (!this.jobCluster.equals(workerId.jobCluster)) {
            return false;
        }
        if (!this.jobId.equals(workerId.jobId)) {
            return false;
        }
        return this.id.equals(workerId.id);
    }

    public int hashCode() {
        int result = this.jobCluster.hashCode();
        result = 31 * result + this.jobId.hashCode();
        result = 31 * result + this.wIndex;
        result = 31 * result + this.wNum;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public String toString() {
        return this.id;
    }
}

