/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.common.WorkerPorts;
import io.mantisrx.runtime.MantisJobDurationType;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class ExecuteStageRequest {
    private final boolean hasJobMaster;
    private final long subscriptionTimeoutSecs;
    private final long minRuntimeSecs;
    private final WorkerPorts workerPorts;
    private String jobName;
    private String jobId;
    private int workerIndex;
    private int workerNumber;
    private URL jobJarUrl;
    private int stage;
    private int totalNumStages;
    private int metricsPort;
    private List<Integer> ports = new LinkedList<Integer>();
    private long timeoutToReportStart;
    private List<Parameter> parameters = new LinkedList<Parameter>();
    private SchedulingInfo schedulingInfo;
    private MantisJobDurationType durationType;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public ExecuteStageRequest(@JsonProperty(value="jobName") String jobName, @JsonProperty(value="jobID") String jobId, @JsonProperty(value="workerIndex") int workerIndex, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="jobJarUrl") URL jobJarUrl, @JsonProperty(value="stage") int stage, @JsonProperty(value="totalNumStages") int totalNumStages, @JsonProperty(value="ports") List<Integer> ports, @JsonProperty(value="timeoutToReportStart") long timeoutToReportStart, @JsonProperty(value="metricsPort") int metricsPort, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="schedulingInfo") SchedulingInfo schedulingInfo, @JsonProperty(value="durationType") MantisJobDurationType durationType, @JsonProperty(value="subscriptionTimeoutSecs") long subscriptionTimeoutSecs, @JsonProperty(value="minRuntimeSecs") long minRuntimeSecs, @JsonProperty(value="workerPorts") WorkerPorts workerPorts) {
        this.jobName = jobName;
        this.jobId = jobId;
        this.workerIndex = workerIndex;
        this.workerNumber = workerNumber;
        this.jobJarUrl = jobJarUrl;
        this.stage = stage;
        this.totalNumStages = totalNumStages;
        this.ports.addAll(ports);
        this.metricsPort = metricsPort;
        this.timeoutToReportStart = timeoutToReportStart;
        this.parameters = parameters != null ? parameters : new LinkedList<Parameter>();
        this.schedulingInfo = schedulingInfo;
        this.durationType = durationType;
        this.hasJobMaster = schedulingInfo != null && schedulingInfo.forStage(0) != null;
        this.subscriptionTimeoutSecs = subscriptionTimeoutSecs;
        this.minRuntimeSecs = minRuntimeSecs;
        this.workerPorts = workerPorts;
    }

    public SchedulingInfo getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public int getWorkerNumber() {
        return this.workerNumber;
    }

    public URL getJobJarUrl() {
        return this.jobJarUrl;
    }

    public int getStage() {
        return this.stage;
    }

    public int getTotalNumStages() {
        return this.totalNumStages;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public WorkerPorts getWorkerPorts() {
        return this.workerPorts;
    }

    public long getTimeoutToReportStart() {
        return this.timeoutToReportStart;
    }

    public MantisJobDurationType getDurationType() {
        return this.durationType;
    }

    public boolean getHasJobMaster() {
        return this.hasJobMaster;
    }

    public long getSubscriptionTimeoutSecs() {
        return this.subscriptionTimeoutSecs;
    }

    public long getMinRuntimeSecs() {
        return this.minRuntimeSecs;
    }

    public String toString() {
        return "ExecuteStageRequest{jobName='" + this.jobName + '\'' + ", jobId='" + this.jobId + '\'' + ", workerIndex=" + this.workerIndex + ", workerNumber=" + this.workerNumber + ", jobJarUrl=" + this.jobJarUrl + ", stage=" + this.stage + ", totalNumStages=" + this.totalNumStages + ", metricsPort=" + this.metricsPort + ", ports=" + this.ports + ", timeoutToReportStart=" + this.timeoutToReportStart + ", parameters=" + this.parameters + ", schedulingInfo=" + this.schedulingInfo + ", durationType=" + this.durationType + ", hasJobMaster=" + this.hasJobMaster + ", subscriptionTimeoutSecs=" + this.subscriptionTimeoutSecs + ", minRuntimeSecs=" + this.minRuntimeSecs + ", workerPorts=" + this.workerPorts + '}';
    }
}

