/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.stats;

import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import java.util.ArrayDeque;

public class UsageDataStats {
    private final int capacity;
    private final ArrayDeque<Double> data;
    private final double highThreshold;
    private final double lowThreshold;
    private double sum = 0.0;
    private int countAboveHighThreshold = 0;
    private int countBelowLowThreshold = 0;
    private StageScalingPolicy.RollingCount rollingCount = new StageScalingPolicy.RollingCount(1, 1);

    public UsageDataStats(double highThreshold, double lowThreshold, StageScalingPolicy.RollingCount rollingCount) {
        this.capacity = rollingCount.getOf();
        this.data = new ArrayDeque(this.capacity);
        this.highThreshold = highThreshold;
        this.lowThreshold = lowThreshold;
        this.rollingCount = rollingCount;
    }

    public void add(double d) {
        if (this.data.size() >= this.capacity) {
            Double removed = this.data.removeFirst();
            this.sum -= removed.doubleValue();
            if (removed > this.highThreshold) {
                --this.countAboveHighThreshold;
            }
            if (removed < this.lowThreshold && this.lowThreshold > 0.0) {
                --this.countBelowLowThreshold;
            }
        }
        this.data.addLast(d);
        this.sum += d;
        if (d > this.highThreshold) {
            ++this.countAboveHighThreshold;
        }
        if (d < this.lowThreshold && this.lowThreshold > 0.0) {
            ++this.countBelowLowThreshold;
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public double getAverage() {
        return this.sum / (double)this.data.size();
    }

    public int getCountAboveHighThreshold() {
        return this.countAboveHighThreshold;
    }

    public int getCountBelowLowThreshold() {
        return this.countBelowLowThreshold;
    }

    public int getSize() {
        return this.data.size();
    }

    public boolean getHighThreshTriggered() {
        return this.data.size() >= this.rollingCount.getCount() && this.countAboveHighThreshold >= this.rollingCount.getCount();
    }

    public boolean getLowThreshTriggered() {
        return this.data.size() >= this.rollingCount.getCount() && this.countBelowLowThreshold >= this.rollingCount.getCount();
    }

    public String getCurrentHighCount() {
        return this.countAboveHighThreshold + " of " + this.data.size();
    }

    public String getCurrentLowCount() {
        return this.countBelowLowThreshold + " of " + this.data.size();
    }
}

