/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.core.domain.WorkerId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Status {
    private static final ObjectMapper mapper = new ObjectMapper();
    @JsonIgnore
    private final Optional<WorkerId> workerId;
    private String jobId;
    private int stageNum;
    private int workerIndex;
    private int workerNumber;
    private String hostname = null;
    private TYPE type;
    private String message;
    private long timestamp;
    private MantisJobState state;
    private JobCompletedReason reason = JobCompletedReason.Normal;
    private List<Payload> payloads;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public Status(@JsonProperty(value="jobId") String jobId, @JsonProperty(value="stageNum") int stageNum, @JsonProperty(value="workerIndex") int workerIndex, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="type") TYPE type, @JsonProperty(value="message") String message, @JsonProperty(value="state") MantisJobState state) {
        this(jobId, stageNum, workerIndex, workerNumber, type, message, state, System.currentTimeMillis());
    }

    public Status(String jobId, int stageNum, int workerIndex, int workerNumber, TYPE type, String message, MantisJobState state, long ts) {
        this.jobId = jobId;
        this.stageNum = stageNum;
        this.workerIndex = workerIndex;
        this.workerNumber = workerNumber;
        this.workerId = workerIndex >= 0 && workerNumber >= 0 ? Optional.of(new WorkerId(jobId, workerIndex, workerNumber)) : Optional.empty();
        this.type = type;
        this.message = message;
        this.state = state;
        this.timestamp = ts;
        this.payloads = new ArrayList<Payload>();
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getStageNum() {
        return this.stageNum;
    }

    public void setStageNum(int stageNum) {
        this.stageNum = stageNum;
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    public void setWorkerIndex(int workerIndex) {
        this.workerIndex = workerIndex;
    }

    public int getWorkerNumber() {
        return this.workerNumber;
    }

    public Optional<WorkerId> getWorkerId() {
        return this.workerId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public TYPE getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public MantisJobState getState() {
        return this.state;
    }

    public JobCompletedReason getReason() {
        return this.reason;
    }

    public void setReason(JobCompletedReason reason) {
        this.reason = reason;
    }

    public List<Payload> getPayloads() {
        return this.payloads;
    }

    public void setPayloads(List<Payload> payloads) {
        this.payloads = payloads;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Error getting string for status on job " + this.jobId;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class Payload {
        private final String type;
        private final String data;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public Payload(@JsonProperty(value="type") String type, @JsonProperty(value="data") String data) {
            this.type = type;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public String getData() {
            return this.data;
        }
    }

    public static enum TYPE {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        HEARTBEAT;

    }
}

