/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.zookeeper;

import com.google.common.util.concurrent.MoreExecutors;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.server.core.BaseService;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.core.master.ZookeeperMasterMonitor;
import java.util.concurrent.Executor;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.imps.GzipCompressionProvider;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorService.class);
    private static final String isConnectedGaugeName = "isConnected";
    private final CuratorFramework curator;
    private final ZookeeperMasterMonitor masterMonitor;
    private final CoreConfiguration configs;
    private final Gauge isConnectedGauge;

    public CuratorService(CoreConfiguration configs, MasterDescription initialMasterDescription) {
        super(false);
        this.configs = configs;
        Metrics m = new Metrics.Builder().name(CuratorService.class.getCanonicalName()).addGauge(isConnectedGaugeName).build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.isConnectedGauge = m.getGauge(isConnectedGaugeName);
        this.curator = CuratorFrameworkFactory.builder().compressionProvider((CompressionProvider)new GzipCompressionProvider()).connectionTimeoutMs(configs.getZkConnectionTimeoutMs()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(configs.getZkConnectionRetrySleepMs(), configs.getZkConnectionMaxRetries())).connectString(configs.getZkConnectionString()).build();
        this.masterMonitor = new ZookeeperMasterMonitor(this.curator, ZKPaths.makePath((String)configs.getZkRoot(), (String)configs.getLeaderAnnouncementPath()), initialMasterDescription);
    }

    private void setupCuratorListener() {
        LOG.info("Setting up curator state change listener");
        this.curator.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (newState.isConnected()) {
                    LOG.info("Curator connected");
                    CuratorService.this.isConnectedGauge.set(1L);
                } else {
                    LOG.error("Curator connection lost");
                    CuratorService.this.isConnectedGauge.set(0L);
                }
            }
        }, (Executor)MoreExecutors.newDirectExecutorService());
    }

    @Override
    public void start() {
        this.isConnectedGauge.set(0L);
        this.setupCuratorListener();
        this.curator.start();
        this.masterMonitor.start();
    }

    @Override
    public void shutdown() {
        try {
            this.masterMonitor.shutdown();
            this.curator.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to shut down the curator service: " + e.getMessage(), (Throwable)e);
        }
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public MasterMonitor getMasterMonitor() {
        return this.masterMonitor;
    }
}

