/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core.master;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

public class MasterDescription {
    public static final String JSON_PROP_HOSTNAME = "hostname";
    public static final String JSON_PROP_HOST_IP = "hostIP";
    public static final String JSON_PROP_API_PORT = "apiPort";
    public static final String JSON_PROP_SCHED_INFO_PORT = "schedInfoPort";
    public static final String JSON_PROP_API_PORT_V2 = "apiPortV2";
    public static final String JSON_PROP_API_STATUS_URI = "apiStatusUri";
    public static final String JSON_PROP_CONSOLE_PORT = "consolePort";
    public static final String JSON_PROP_CREATE_TIME = "createTime";
    private final String hostname;
    private final String hostIP;
    private final int apiPort;
    private final int schedInfoPort;
    private final int apiPortV2;
    private final String apiStatusUri;
    private final long createTime;
    private final int consolePort;

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MasterDescription(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="hostIP") String hostIP, @JsonProperty(value="apiPort") int apiPort, @JsonProperty(value="schedInfoPort") int schedInfoPort, @JsonProperty(value="apiPortV2") int apiPortV2, @JsonProperty(value="apiStatusUri") String apiStatusUri, @JsonProperty(value="consolePort") int consolePort, @JsonProperty(value="createTime") long createTime) {
        this.hostname = hostname;
        this.hostIP = hostIP;
        this.apiPort = apiPort;
        this.schedInfoPort = schedInfoPort;
        this.apiPortV2 = apiPortV2;
        this.apiStatusUri = apiStatusUri;
        this.consolePort = consolePort;
        this.createTime = createTime;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostIP")
    public String getHostIP() {
        return this.hostIP;
    }

    @JsonProperty(value="apiPort")
    public int getApiPort() {
        return this.apiPort;
    }

    @JsonProperty(value="schedInfoPort")
    public int getSchedInfoPort() {
        return this.schedInfoPort;
    }

    @JsonProperty(value="apiPortV2")
    public int getApiPortV2() {
        return this.apiPortV2;
    }

    @JsonProperty(value="apiStatusUri")
    public String getApiStatusUri() {
        return this.apiStatusUri;
    }

    @JsonProperty(value="createTime")
    public long getCreateTime() {
        return this.createTime;
    }

    public String getFullApiStatusUri() {
        String uri = this.getApiStatusUri().trim();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return String.format("http://%s:%d/%s", this.getHostname(), this.getApiPort(), uri);
    }

    @JsonProperty(value="consolePort")
    public int getConsolePort() {
        return this.consolePort;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add(JSON_PROP_HOSTNAME, (Object)this.hostname).add(JSON_PROP_HOST_IP, (Object)this.hostIP).add(JSON_PROP_API_PORT, this.apiPort).add(JSON_PROP_SCHED_INFO_PORT, this.schedInfoPort).add(JSON_PROP_API_PORT_V2, this.apiPortV2).add(JSON_PROP_API_STATUS_URI, (Object)this.apiStatusUri).add(JSON_PROP_CREATE_TIME, this.createTime).add(JSON_PROP_CONSOLE_PORT, this.consolePort).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MasterDescription that = (MasterDescription)o;
        if (this.apiPort != that.apiPort) {
            return false;
        }
        if (this.schedInfoPort != that.schedInfoPort) {
            return false;
        }
        if (this.apiPortV2 != that.apiPortV2) {
            return false;
        }
        if (this.consolePort != that.consolePort) {
            return false;
        }
        if (this.createTime != that.createTime) {
            return false;
        }
        if (this.apiStatusUri != null ? !this.apiStatusUri.equals(that.apiStatusUri) : that.apiStatusUri != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        return this.hostname != null ? this.hostname.equals(that.hostname) : that.hostname == null;
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.hostIP != null ? this.hostIP.hashCode() : 0);
        result = 31 * result + this.apiPort;
        result = 31 * result + this.apiPortV2;
        result = 31 * result + (this.apiStatusUri != null ? this.apiStatusUri.hashCode() : 0);
        result = 31 * result + (int)(this.createTime ^ this.createTime >>> 32);
        result = 31 * result + this.consolePort;
        return result;
    }
}

