/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client.diagnostic.plugin;

import io.mantisrx.server.master.client.diagnostic.plugin.DiagnosticMessageType;
import java.util.Map;

public class DiagnosticMessage {
    private final DiagnosticMessageType messageType;
    private final Throwable error;
    private final Map<String, String> tags;
    private final String description;

    private DiagnosticMessage(Builder builder) {
        this.messageType = builder.messageType;
        this.error = builder.error;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public static Builder builder(DiagnosticMessageType messageType) {
        return new Builder(messageType);
    }

    public DiagnosticMessageType getMessageType() {
        return this.messageType;
    }

    public Throwable getError() {
        return this.error;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "DiagnosticMessage [messageType=" + (Object)((Object)this.messageType) + ", error=" + this.error + ", tags=" + this.tags + ", description=" + this.description + "]";
    }

    public static class Builder {
        private final DiagnosticMessageType messageType;
        private Throwable error;
        private String description;
        private Map<String, String> tags;

        private Builder(DiagnosticMessageType messageType) {
            this.messageType = messageType;
        }

        public Builder withError(Throwable error) {
            this.error = error;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public DiagnosticMessage build() {
            return new DiagnosticMessage(this);
        }
    }
}

