/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.resourcecluster;

import com.spotify.futures.CompletableFutures;
import io.mantisrx.common.Ack;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ResourceClusterGateway;
import io.mantisrx.server.master.resourcecluster.TaskExecutorDisconnection;
import io.mantisrx.server.master.resourcecluster.TaskExecutorHeartbeat;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.master.resourcecluster.TaskExecutorStatusChange;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClusterGatewayClient
implements ResourceClusterGateway,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterGatewayClient.class);
    private final ClusterID clusterID;
    private final MasterDescription masterDescription;
    private AsyncHttpClient client;
    private final ObjectMapper mapper;

    public ResourceClusterGatewayClient(ClusterID clusterID, MasterDescription masterDescription, CoreConfiguration configuration) {
        this.clusterID = clusterID;
        this.masterDescription = masterDescription;
        this.mapper = new ObjectMapper();
        this.client = this.buildCloseableHttpClient(configuration);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public CompletableFuture<Ack> registerTaskExecutor(TaskExecutorRegistration registration) {
        return this.performAction("registerTaskExecutor", registration);
    }

    public CompletableFuture<Ack> heartBeatFromTaskExecutor(TaskExecutorHeartbeat heartbeat) {
        return this.performAction("heartBeatFromTaskExecutor", heartbeat);
    }

    public CompletableFuture<Ack> notifyTaskExecutorStatusChange(TaskExecutorStatusChange taskExecutorStatusChange) {
        return this.performAction("notifyTaskExecutorStatusChange", taskExecutorStatusChange);
    }

    public CompletableFuture<Ack> disconnectTaskExecutor(TaskExecutorDisconnection taskExecutorDisconnection) {
        return this.performAction("disconnectTaskExecutor", taskExecutorDisconnection);
    }

    private CompletableFuture<Ack> performAction(String action, Object body) {
        try {
            String bodyStr = this.mapper.writeValueAsString(body);
            Request request = ((RequestBuilder)((RequestBuilder)Dsl.post((String)this.getActionUri(action)).setBody(bodyStr)).addHeader((CharSequence)"Content-Type", "application/json")).build();
            log.debug("request={}", (Object)request);
            return this.client.executeRequest(request).toCompletableFuture().thenCompose(response -> {
                if (response.getStatusCode() == 200) {
                    return CompletableFuture.completedFuture(Ack.getInstance());
                }
                try {
                    log.error("failed request {} with response {}", (Object)request, (Object)response.getResponseBody());
                    return CompletableFutures.exceptionallyCompletedFuture((Throwable)((Throwable)this.mapper.readValue(response.getResponseBody(), Throwable.class)));
                }
                catch (Exception e) {
                    return CompletableFutures.exceptionallyCompletedFuture((Throwable)new Exception(String.format("response=%s", response), e));
                }
            });
        }
        catch (Exception e) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        }
    }

    private String getActionUri(String action) {
        String uri = String.format("http://%s:%d/api/v1/resourceClusters/%s/actions/%s", this.masterDescription.getHostname(), this.masterDescription.getApiPort(), this.clusterID.getResourceID(), action);
        log.debug("uri={}", (Object)uri);
        return uri;
    }

    private AsyncHttpClient buildCloseableHttpClient(CoreConfiguration configuration) {
        return Dsl.asyncHttpClient((AsyncHttpClientConfig)new DefaultAsyncHttpClientConfig.Builder().setMaxConnections(configuration.getAsyncHttpClientMaxConnectionsPerHost()).setConnectTimeout(configuration.getAsyncHttpClientConnectionTimeoutMs()).setRequestTimeout(configuration.getAsyncHttpClientRequestTimeoutMs()).setReadTimeout(configuration.getAsyncHttpClientReadTimeoutMs()).build());
    }

    public String toString() {
        return "ResourceClusterGatewayClient(clusterID=" + this.clusterID + ", masterDescription=" + this.getMasterDescription() + ")";
    }

    public MasterDescription getMasterDescription() {
        return this.masterDescription;
    }
}

