/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.master.LocalMasterMonitor;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.core.zookeeper.CuratorService;
import io.mantisrx.server.master.client.HighAvailabilityServices;
import io.mantisrx.server.master.client.MantisMasterClientApi;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.server.master.client.ResourceLeaderConnection;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ResourceClusterGateway;
import io.mantisrx.server.master.resourcecluster.ResourceClusterGatewayClient;
import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractIdleService;
import io.mantisrx.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.Schedulers;

public class HighAvailabilityServicesUtil {
    private static final Logger log = LoggerFactory.getLogger(HighAvailabilityServicesUtil.class);
    private static final AtomicReference<HighAvailabilityServices> HAServiceInstanceRef = new AtomicReference();

    public static HighAvailabilityServices createHAServices(CoreConfiguration configuration) {
        if (configuration.isLocalMode()) {
            log.warn("HA service running in local mode. This is only valid in local test.");
            if (HAServiceInstanceRef.get() == null) {
                String[] parts = configuration.getZkConnectionString().split(":");
                if (parts.length != 2) {
                    throw new RuntimeException("invalid local mode connection string: " + configuration.getZkConnectionString());
                }
                int apiPort = Integer.parseInt(parts[1]);
                HAServiceInstanceRef.compareAndSet(null, new LocalHighAvailabilityServices(new MasterDescription(parts[0], "127.0.0.1", apiPort, apiPort, apiPort, "api/postjobstatus", apiPort + 6, System.currentTimeMillis()), configuration));
            }
        } else if (HAServiceInstanceRef.get() == null) {
            HAServiceInstanceRef.compareAndSet(null, new ZkHighAvailabilityServices(configuration));
        }
        return HAServiceInstanceRef.get();
    }

    private static class ZkHighAvailabilityServices
    extends AbstractIdleService
    implements HighAvailabilityServices {
        private final CuratorService curatorService;
        private final Counter resourceLeaderChangeCounter;
        private final Counter resourceLeaderAlreadyRegisteredCounter;
        private final AtomicInteger rmConnections = new AtomicInteger(0);
        private final CoreConfiguration configuration;

        public ZkHighAvailabilityServices(CoreConfiguration configuration) {
            this.curatorService = new CuratorService(configuration);
            Metrics metrics = MetricsRegistry.getInstance().registerAndGet(new Metrics.Builder().name("ZkHighAvailabilityServices").addCounter("resourceLeaderChangeCounter").addCounter("resourceLeaderAlreadyRegisteredCounter").build());
            this.resourceLeaderChangeCounter = metrics.getCounter("resourceLeaderChangeCounter");
            this.resourceLeaderAlreadyRegisteredCounter = metrics.getCounter("resourceLeaderAlreadyRegisteredCounter");
            this.configuration = configuration;
        }

        protected void startUp() throws Exception {
            this.curatorService.start();
        }

        protected void shutDown() throws Exception {
            this.curatorService.shutdown();
        }

        @Override
        public MantisMasterGateway getMasterClientApi() {
            return new MantisMasterClientApi(this.curatorService.getMasterMonitor());
        }

        @Override
        public MasterMonitor getMasterMonitor() {
            return this.curatorService.getMasterMonitor();
        }

        @Override
        public ResourceLeaderConnection<ResourceClusterGateway> connectWithResourceManager(final ClusterID clusterID) {
            return new ResourceLeaderConnection<ResourceClusterGateway>(){
                final MasterMonitor masterMonitor;
                ResourceClusterGateway currentResourceClusterGateway;
                final String nameFormat;
                final Scheduler scheduler;
                final List<Subscription> subscriptions;
                {
                    this.masterMonitor = curatorService.getMasterMonitor();
                    this.currentResourceClusterGateway = new ResourceClusterGatewayClient(clusterID, this.masterMonitor.getLatestMaster(), configuration);
                    this.nameFormat = "ResourceClusterGatewayCxn (" + rmConnections.getAndIncrement() + ")-%d";
                    this.scheduler = Schedulers.from((Executor)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.nameFormat).build()));
                    this.subscriptions = new ArrayList<Subscription>();
                }

                @Override
                public ResourceClusterGateway getCurrent() {
                    return this.currentResourceClusterGateway;
                }

                @Override
                public void register(ResourceLeaderConnection.ResourceLeaderChangeListener<ResourceClusterGateway> changeListener) {
                    Subscription subscription = this.masterMonitor.getMasterObservable().observeOn(this.scheduler).subscribe(nextDescription -> {
                        log.info("nextDescription={}", nextDescription);
                        if (nextDescription.equals((Object)((ResourceClusterGatewayClient)this.currentResourceClusterGateway).getMasterDescription())) {
                            resourceLeaderAlreadyRegisteredCounter.increment();
                            return;
                        }
                        ResourceClusterGateway previous = this.currentResourceClusterGateway;
                        this.currentResourceClusterGateway = new ResourceClusterGatewayClient(clusterID, (MasterDescription)nextDescription, configuration);
                        resourceLeaderChangeCounter.increment();
                        changeListener.onResourceLeaderChanged(previous, this.currentResourceClusterGateway);
                    });
                    this.subscriptions.add(subscription);
                }
            };
        }
    }

    private static class LocalHighAvailabilityServices
    extends AbstractIdleService
    implements HighAvailabilityServices {
        private final MasterMonitor masterMonitor;
        private final CoreConfiguration configuration;

        public LocalHighAvailabilityServices(MasterDescription masterDescription, CoreConfiguration configuration) {
            this.masterMonitor = new LocalMasterMonitor(masterDescription);
            this.configuration = configuration;
        }

        @Override
        public MantisMasterGateway getMasterClientApi() {
            return new MantisMasterClientApi(this.masterMonitor);
        }

        @Override
        public MasterMonitor getMasterMonitor() {
            return this.masterMonitor;
        }

        @Override
        public ResourceLeaderConnection<ResourceClusterGateway> connectWithResourceManager(final ClusterID clusterID) {
            return new ResourceLeaderConnection<ResourceClusterGateway>(){
                final MasterMonitor masterMonitor;
                {
                    this.masterMonitor = masterMonitor;
                }

                @Override
                public ResourceClusterGateway getCurrent() {
                    return new ResourceClusterGatewayClient(clusterID, this.masterMonitor.getLatestMaster(), configuration);
                }

                @Override
                public void register(ResourceLeaderConnection.ResourceLeaderChangeListener<ResourceClusterGateway> changeListener) {
                }
            };
        }

        protected void startUp() throws Exception {
        }

        protected void shutDown() throws Exception {
        }
    }
}

