/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.server.core.Status;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.server.master.client.TaskStatusUpdateHandler;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusUpdateHandlerImpl
implements TaskStatusUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(TaskStatusUpdateHandlerImpl.class);
    private final Counter failureCounter;
    private final Counter workerSentHeartbeats;
    private final MantisMasterGateway masterMonitor;

    TaskStatusUpdateHandlerImpl(MantisMasterGateway masterGateway) {
        Metrics metrics = MetricsRegistry.getInstance().registerAndGet(new Metrics.Builder().name("ReportStatusServiceHttpImpl").addCounter("failureCounter").addCounter("workerSentHeartbeats").build());
        this.failureCounter = metrics.getCounter("failureCounter");
        this.workerSentHeartbeats = metrics.getCounter("workerSentHeartbeats");
        this.masterMonitor = masterGateway;
    }

    @Override
    public void onStatusUpdate(Status status) {
        log.info("onStatusUpdate for status: {}", (Object)status);
        this.masterMonitor.updateStatus(status).whenComplete((ack, throwable) -> {
            if (ack != null) {
                this.workerSentHeartbeats.increment();
            } else {
                Throwable cleaned = ExceptionUtils.stripExecutionException((Throwable)throwable);
                this.failureCounter.increment();
                log.error("Failed to send status update", cleaned);
            }
        });
    }
}

