/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client;

import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.core.zookeeper.CuratorService;
import io.mantisrx.server.master.client.HighAvailabilityServices;
import io.mantisrx.server.master.client.MantisMasterClientApi;
import io.mantisrx.server.master.client.MantisMasterGateway;
import io.mantisrx.server.master.client.ResourceLeaderConnection;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ResourceClusterGateway;
import io.mantisrx.server.master.resourcecluster.ResourceClusterGatewayClient;
import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractIdleService;
import io.mantisrx.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.Schedulers;

public class HighAvailabilityServicesUtil {
    private static final Logger log = LoggerFactory.getLogger(HighAvailabilityServicesUtil.class);
    private static final AtomicReference<HighAvailabilityServices> HAServiceInstanceRef = new AtomicReference();

    public static HighAvailabilityServices createHAServices(CoreConfiguration configuration) {
        if (configuration.isLocalMode()) {
            throw new UnsupportedOperationException();
        }
        if (HAServiceInstanceRef.get() == null) {
            HAServiceInstanceRef.compareAndSet(null, new ZkHighAvailabilityServices(configuration));
        }
        return HAServiceInstanceRef.get();
    }

    private static class ZkHighAvailabilityServices
    extends AbstractIdleService
    implements HighAvailabilityServices {
        private final CuratorService curatorService;
        private final AtomicInteger rmConnections = new AtomicInteger(0);

        public ZkHighAvailabilityServices(CoreConfiguration configuration) {
            this.curatorService = new CuratorService(configuration);
        }

        protected void startUp() throws Exception {
            this.curatorService.start();
        }

        protected void shutDown() throws Exception {
            this.curatorService.shutdown();
        }

        @Override
        public MantisMasterGateway getMasterClientApi() {
            return new MantisMasterClientApi(this.curatorService.getMasterMonitor());
        }

        @Override
        public MasterMonitor getMasterMonitor() {
            return this.curatorService.getMasterMonitor();
        }

        @Override
        public ResourceLeaderConnection<ResourceClusterGateway> connectWithResourceManager(final ClusterID clusterID) {
            return new ResourceLeaderConnection<ResourceClusterGateway>(){
                final MasterMonitor masterMonitor;
                ResourceClusterGateway currentResourceClusterGateway;
                final String nameFormat;
                final Scheduler scheduler;
                final List<Subscription> subscriptions;
                {
                    this.masterMonitor = curatorService.getMasterMonitor();
                    this.currentResourceClusterGateway = new ResourceClusterGatewayClient(clusterID, this.masterMonitor.getLatestMaster());
                    this.nameFormat = "ResourceClusterGatewayCxn (" + rmConnections.getAndIncrement() + ")-%d";
                    this.scheduler = Schedulers.from((Executor)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.nameFormat).build()));
                    this.subscriptions = new ArrayList<Subscription>();
                }

                @Override
                public ResourceClusterGateway getCurrent() {
                    return this.currentResourceClusterGateway;
                }

                @Override
                public void register(ResourceLeaderConnection.ResourceLeaderChangeListener<ResourceClusterGateway> changeListener) {
                    Subscription subscription = this.masterMonitor.getMasterObservable().observeOn(this.scheduler).subscribe(nextDescription -> {
                        log.info("nextDescription={}", nextDescription);
                        ResourceClusterGateway previous = this.currentResourceClusterGateway;
                        this.currentResourceClusterGateway = new ResourceClusterGatewayClient(clusterID, (MasterDescription)nextDescription);
                        changeListener.onResourceLeaderChanged(previous, this.currentResourceClusterGateway);
                    });
                    this.subscriptions.add(subscription);
                }
            };
        }
    }
}

