/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.server.core.JobAssignmentResult;
import io.mantisrx.server.master.client.MantisMasterClientApi;
import io.mantisrx.server.master.client.MasterClientWrapper;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

public class SimpleSchedulerObserver {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @Argument(alias="p", description="Specify a configuration file", required=true)
    private static String propFile = "";
    @Argument(alias="j", description="Specify a jobId", required=false)
    private static String jobId = "";
    private final MasterClientWrapper clientWrapper;

    SimpleSchedulerObserver(Properties properties) {
        this.clientWrapper = new MasterClientWrapper(properties);
    }

    public static void main(String[] args) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)new Jdk8Module());
        try {
            Args.parse(SimpleSchedulerObserver.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(SimpleSchedulerObserver.class);
            System.exit(1);
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Listening to scheduling assignments with jobId=" + jobId);
        final CountDownLatch latch = new CountDownLatch(1);
        SimpleSchedulerObserver schedulerObserver = new SimpleSchedulerObserver(properties);
        final AtomicReference<Object> ref = new AtomicReference<Object>(null);
        schedulerObserver.getObservable(jobId).filter((Func1)new Func1<JobAssignmentResult, Boolean>(){

            public Boolean call(JobAssignmentResult jobAssignmentResult) {
                if (jobAssignmentResult == null) {
                    return false;
                }
                if (jobAssignmentResult.isIdentical((JobAssignmentResult)ref.get())) {
                    return false;
                }
                ref.set(jobAssignmentResult);
                return true;
            }
        }).doOnNext((Action1)new Action1<JobAssignmentResult>(){

            public void call(JobAssignmentResult jobAssignmentResult) {
                System.out.println("Failures for job " + jobAssignmentResult.getJobId() + ":");
                for (JobAssignmentResult.Failure failure : jobAssignmentResult.getFailures()) {
                    try {
                        System.out.println("  " + objectMapper.writeValueAsString((Object)failure));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                latch.countDown();
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                throwable.printStackTrace();
                latch.countDown();
            }
        }).subscribe();
        System.out.println("Subscribed.");
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    Observable<JobAssignmentResult> getObservable(final String jobId) {
        return this.clientWrapper.getMasterClientApi().flatMap((Func1)new Func1<MantisMasterClientApi, Observable<? extends JobAssignmentResult>>(){

            public Observable<? extends JobAssignmentResult> call(MantisMasterClientApi mantisMasterClientApi) {
                return mantisMasterClientApi.assignmentResults(jobId);
            }
        });
    }
}

