/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.core.zookeeper.CuratorService;
import io.mantisrx.server.master.client.config.StaticPropertiesConfigurationFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import rx.functions.Action1;
import rx.functions.Func1;

public class TestGetMasterMonitor {
    @Argument(alias="p", description="Specify a configuration file", required=true)
    private static String propFile = "";

    public static void main(String[] args) {
        try {
            Args.parse(TestGetMasterMonitor.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(TestGetMasterMonitor.class);
            System.exit(1);
        }
        Properties properties = new Properties();
        System.out.println("propfile=" + propFile);
        try (FileInputStream inputStream = new FileInputStream(propFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        final AtomicInteger counter = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(5);
        StaticPropertiesConfigurationFactory configurationFactory = new StaticPropertiesConfigurationFactory(properties);
        CoreConfiguration config = configurationFactory.getConfig();
        CuratorService curatorService = new CuratorService(config, null);
        MasterMonitor masterMonitor = curatorService.getMasterMonitor();
        masterMonitor.getMasterObservable().filter((Func1)new Func1<MasterDescription, Boolean>(){

            public Boolean call(MasterDescription masterDescription) {
                return masterDescription != null;
            }
        }).doOnNext((Action1)new Action1<MasterDescription>(){

            public void call(MasterDescription masterDescription) {
                System.out.println(counter.incrementAndGet() + ": Got new master: " + masterDescription.toString());
                latch.countDown();
            }
        }).subscribe();
        curatorService.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

