/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client;

import io.mantisrx.common.metrics.Counter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class ConditionalRetry {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalRetry.class);
    private final Counter counter;
    private final String name;
    private final AtomicReference<Throwable> errorRef = new AtomicReference<Object>(null);
    private final Func1<Observable<? extends Throwable>, Observable<?>> retryLogic;

    public ConditionalRetry(Counter counter, String name) {
        this(counter, name, Integer.MAX_VALUE);
    }

    public ConditionalRetry(Counter counter, String name, final int max) {
        this.counter = counter;
        this.name = name;
        this.retryLogic = new Func1<Observable<? extends Throwable>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Throwable> attempts) {
                return attempts.zipWith(Observable.range((int)1, (int)max), (Func2)new Func2<Throwable, Integer, Integer>(){

                    public Integer call(Throwable t1, Integer integer) {
                        return integer;
                    }
                }).flatMap(new Func1<Integer, Observable<?>>(){

                    public Observable<?> call(Integer integer) {
                        if (ConditionalRetry.this.errorRef.get() != null) {
                            return Observable.error((Throwable)((Throwable)ConditionalRetry.this.errorRef.get()));
                        }
                        if (ConditionalRetry.this.counter != null) {
                            ConditionalRetry.this.counter.increment();
                        }
                        long delay = 2 * (integer > 10 ? 10 : integer);
                        logger.info(": retrying " + ConditionalRetry.this.name + " after sleeping for " + delay + " secs");
                        return Observable.timer((long)delay, (TimeUnit)TimeUnit.SECONDS);
                    }
                });
            }
        };
    }

    public void setErrorRef(Throwable error) {
        this.errorRef.set(error);
    }

    public Counter getCounter() {
        return this.counter;
    }

    public Func1<Observable<? extends Throwable>, Observable<?>> getRetryLogic() {
        return this.retryLogic;
    }
}

