/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import mantis.io.reactivex.netty.protocol.http.client.CompositeHttpClientBuilder;
import mantis.io.reactivex.netty.protocol.http.client.HttpClient;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

class HttpUtility {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtility.class);
    private static final long GET_TIMEOUT_SECS = 30L;
    private static final int MAX_REDIRECTS = 10;

    HttpUtility() {
    }

    static Observable<String> getGetResponse(String host, int port, String uri) {
        return ((CompositeHttpClient)((CompositeHttpClientBuilder)new CompositeHttpClientBuilder().appendPipelineConfigurator((PipelineConfigurator)new PipelineConfigurator<HttpClientResponse<ByteBuf>, HttpClientRequest<ByteBuf>>(){

            public void configureNewPipeline(ChannelPipeline pipeline) {
                pipeline.addLast("introspecting-handler", (ChannelHandler)new ChannelDuplexHandler(){
                    private String uri = "<undefined>";

                    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                        if (msg instanceof HttpRequest) {
                            HttpRequest request = (HttpRequest)msg;
                            this.uri = request.getUri();
                            logger.info("Sending request on channel id: " + ctx.channel().toString() + ", request URI: " + this.uri);
                        }
                        super.write(ctx, msg, promise);
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof HttpResponse) {
                            logger.info("Received response on channel id: " + ctx.channel().toString() + ", request URI: " + this.uri);
                        }
                        super.channelRead(ctx, msg);
                    }
                });
            }
        })).build()).submit(new RxClient.ServerInfo(host, port), HttpClientRequest.createGet((String)uri), (HttpClient.HttpClientConfig)new HttpClient.HttpClientConfig.Builder().setFollowRedirect(true).followRedirect(10).build()).flatMap((Func1)new Func1<HttpClientResponse<ByteBuf>, Observable<ByteBuf>>(){

            public Observable<ByteBuf> call(HttpClientResponse<ByteBuf> response) {
                return response.getContent();
            }
        }).map((Func1)new Func1<ByteBuf, String>(){

            public String call(ByteBuf o) {
                return o.toString(Charset.defaultCharset());
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.warn("Error: " + throwable.getMessage(), throwable);
            }
        }).timeout(30L, TimeUnit.SECONDS);
    }
}

