/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connectors.publish.source.http;

import io.mantisrx.connectors.publish.core.QueryRegistry;
import io.mantisrx.connectors.publish.source.http.HttpServerInitializer;
import io.mantisrx.connectors.publish.source.http.SourceHttpServer;
import io.mantisrx.runtime.Context;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.subjects.Subject;

public class NettySourceHttpServer
implements SourceHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettySourceHttpServer.class);
    private final NioEventLoopGroup workerGroup;
    private final NioEventLoopGroup bossGroup;
    private Runnable nettyServerRunnable;
    private volatile boolean isInitialized = false;
    private volatile boolean isStarted = false;

    public NettySourceHttpServer(Context context, int threadCount) {
        this.bossGroup = new NioEventLoopGroup(threadCount);
        this.workerGroup = new NioEventLoopGroup();
    }

    @Override
    public void init(QueryRegistry queryRegistry, Subject<String, String> eventSubject, int port) {
        if (!this.isInitialized) {
            this.nettyServerRunnable = () -> {
                try {
                    ServerBootstrap b = new ServerBootstrap();
                    b.option(ChannelOption.SO_BACKLOG, (Object)1024);
                    ((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer(queryRegistry, eventSubject));
                    Channel ch = b.bind(port).sync().channel();
                    ch.closeFuture().sync();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
                finally {
                    this.bossGroup.shutdownGracefully();
                    this.workerGroup.shutdownGracefully();
                }
            };
            this.isInitialized = true;
        }
    }

    @Override
    public void startServer() {
        if (!this.isInitialized || this.isStarted) {
            throw new IllegalStateException("Server already started");
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(this.nettyServerRunnable);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownServer));
        this.isStarted = true;
    }

    @Override
    public void shutdownServer() {
        if (this.isInitialized && this.isStarted) {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }
    }
}

