/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connectors.publish.source.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyExceptionHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private static Logger logger = LoggerFactory.getLogger(NettyExceptionHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest message) {
        logger.warn("Unknown message received: {}", (Object)message);
        NettyExceptionHandler.sendResponse(ctx, false, message + " Bad request received.", HttpResponseStatus.BAD_REQUEST, this.responseHeaders);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.warn("Unhandled exception", cause);
        NettyExceptionHandler.sendResponse(ctx, false, "Internal server error: " + cause.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, this.responseHeaders);
    }

    public static CompletableFuture<Void> sendResponse(ChannelHandlerContext channelHandlerContext, boolean keepAlive, String message, HttpResponseStatus statusCode, Map<String, String> headers) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            response.headers().set(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        byte[] buf = message.getBytes(StandardCharsets.UTF_8);
        ByteBuf b = Unpooled.copiedBuffer((byte[])buf);
        HttpUtil.setContentLength((HttpMessage)response, (long)buf.length);
        channelHandlerContext.write((Object)response);
        channelHandlerContext.write((Object)b);
        ChannelFuture lastContentFuture = channelHandlerContext.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return NettyExceptionHandler.toCompletableFuture(lastContentFuture);
    }

    private static CompletableFuture<Void> toCompletableFuture(ChannelFuture channelFuture) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                completableFuture.complete(null);
            } else {
                completableFuture.completeExceptionally(future.cause());
            }
        });
        return completableFuture;
    }
}

