/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connectors.publish.source.http;

import io.mantisrx.connectors.publish.core.QueryRegistry;
import io.mantisrx.connectors.publish.source.http.HttpSourceServerHandler;
import io.mantisrx.connectors.publish.source.http.NettyExceptionHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import rx.subjects.Subject;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final QueryRegistry registry;
    private final Subject<String, String> eventSubject;
    private static final int DEFAULT_MAX_INITIAL_LENGTH = 4096;
    private static final int DEFAULT_MAX_HEADER_SIZE = 16384;
    private static final int DEFAULT_MAX_CHUNK_SIZE = 32768;
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 0x100000;

    public HttpServerInitializer(QueryRegistry registry, Subject<String, String> eventSubject) {
        this.registry = registry;
        this.eventSubject = eventSubject;
    }

    protected void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast("http", (ChannelHandler)new HttpServerCodec(4096, 16384, 32768));
        p.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
        p.addLast(new ChannelHandler[]{new HttpSourceServerHandler(this.registry, this.eventSubject)});
        p.addLast(new ChannelHandler[]{new NettyExceptionHandler()});
    }
}

