/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connectors.publish.core;

import io.mantisrx.connectors.publish.core.ObjectUtils;
import io.mantisrx.connectors.publish.core.QueryMap;
import io.mantisrx.publish.proto.MantisServerSubscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRegistry {
    public static final String ANY = "ANY";
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRegistry.class);
    private final Map<String, String> emptyMap = new HashMap<String, String>(0);
    private final ConcurrentMap<String, QueryMap> appToSubscriptionMap = new ConcurrentHashMap<String, QueryMap>();
    private final String clientIdPrefix;

    private QueryRegistry(String clientIdPrefix) {
        this.clientIdPrefix = clientIdPrefix;
    }

    public void registerQuery(String targetApp, String subId, String query) {
        this.registerQuery(targetApp, subId, query, this.emptyMap, false);
    }

    public void registerQuery(String targetApp, String subId, String query, Map<String, String> additionalParams, boolean validateQueryAsGroovy) {
        ObjectUtils.checkNotNull("subscriptionId", subId);
        ObjectUtils.checkNotNull("query", query);
        ObjectUtils.checkNotNull("targetAppName", targetApp);
        Map<String, String> addParams = additionalParams == null ? this.emptyMap : additionalParams;
        this.appToSubscriptionMap.putIfAbsent(targetApp, new QueryMap(this.clientIdPrefix));
        ((QueryMap)this.appToSubscriptionMap.get(targetApp)).registerQuery(subId, query, additionalParams, validateQueryAsGroovy);
    }

    public boolean deregisterQuery(String targetApp, String subId, String query) {
        this.appToSubscriptionMap.computeIfPresent(targetApp, (k, v) -> {
            v.deregisterQuery(subId, query);
            return v;
        });
        return true;
    }

    public List<MantisServerSubscription> getCurrentSubscriptionsForApp(String app) {
        ArrayList<MantisServerSubscription> subsForApp;
        List<MantisServerSubscription> list = subsForApp = this.appToSubscriptionMap.containsKey(app) ? ((QueryMap)this.appToSubscriptionMap.get(app)).getCurrentSubscriptions() : new ArrayList<MantisServerSubscription>();
        if (!app.equals(ANY) && this.appToSubscriptionMap.containsKey(ANY)) {
            subsForApp.addAll(((QueryMap)this.appToSubscriptionMap.get(ANY)).getCurrentSubscriptions());
        }
        return subsForApp;
    }

    public List<MantisServerSubscription> getCurrentSubscriptions(Map<String, List<String>> queryParams) {
        String app = ANY;
        if (queryParams.containsKey("app")) {
            app = queryParams.get("app").get(0);
        }
        return this.getCurrentSubscriptionsForApp(app);
    }

    public Map<String, List<MantisServerSubscription>> getAllSubscriptions() {
        HashMap<String, List<MantisServerSubscription>> allSubMap = new HashMap<String, List<MantisServerSubscription>>();
        this.appToSubscriptionMap.forEach((s, q) -> allSubMap.put((String)s, q.getCurrentSubscriptions()));
        return allSubMap;
    }

    private String addMantisPrefix(String subId) {
        return this.clientIdPrefix + "_" + subId;
    }

    public static class Builder {
        private String prefix = null;

        public Builder withClientIdPrefix(String prefix) {
            ObjectUtils.checkNotNull("prefix", prefix);
            this.prefix = prefix;
            return this;
        }

        public QueryRegistry build() {
            ObjectUtils.checkNotNull("prefix", this.prefix);
            return new QueryRegistry(this.prefix);
        }
    }
}

