/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connectors.publish.core;

import io.mantisrx.connectors.publish.core.ObjectUtils;
import io.mantisrx.publish.proto.MantisServerSubscription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryMap.class);
    private final Map<String, String> emptyMap = new HashMap<String, String>(0);
    private final ConcurrentHashMap<String, MantisServerSubscriptionWrapper> subscriptionMap = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentMap<String, MantisServerSubscriptionWrapper>> appToSubscriptionMap = new ConcurrentHashMap<String, ConcurrentMap<String, MantisServerSubscriptionWrapper>>();
    private final String clientIdPrefix;

    QueryMap(String clientIdPrefix) {
        this.clientIdPrefix = clientIdPrefix;
    }

    void registerQuery(String subId, String query, Map<String, String> emptyMap) {
        this.registerQuery(subId, query, this.emptyMap, false);
    }

    void registerQuery(String subId, String query, Map<String, String> additionalParams, boolean validateQueryAsGroovy) {
        ObjectUtils.checkNotNull("subscriptionId", subId);
        ObjectUtils.checkNotNull("query", query);
        Map<String, String> addParams = additionalParams == null ? this.emptyMap : additionalParams;
        this.subscriptionMap.computeIfAbsent(subId, s -> new MantisServerSubscriptionWrapper(this.addMantisPrefix(subId), query, addParams)).incrementAndGetRefCount();
    }

    boolean deregisterQuery(String subId, String query) {
        MantisServerSubscriptionWrapper subscription = this.subscriptionMap.computeIfPresent(subId, (k, v) -> {
            v.decrementRefCount();
            return v;
        });
        if (subscription != null) {
            if (subscription.getRefCount() <= 0) {
                LOGGER.info("Subscription ref count is 0 for subscriptionId " + subId + " removing subscription");
                this.subscriptionMap.remove(subId);
            } else {
                LOGGER.info("Subscription ref count decremented for subscriptionId " + subId);
            }
        } else {
            LOGGER.info("Subscription " + subId + " not found");
        }
        return true;
    }

    public List<MantisServerSubscription> getCurrentSubscriptions() {
        return this.subscriptionMap.values().stream().map(MantisServerSubscriptionWrapper::getSubscription).collect(Collectors.toList());
    }

    private String addMantisPrefix(String subId) {
        return this.clientIdPrefix + "_" + subId;
    }

    public static class MantisServerSubscriptionWrapper {
        private final MantisServerSubscription subscription;
        AtomicInteger refCount = new AtomicInteger();

        MantisServerSubscriptionWrapper(String subId, String query, Map<String, String> additionalParams) {
            this.subscription = new MantisServerSubscription(subId, query, additionalParams);
        }

        MantisServerSubscription getSubscription() {
            return this.subscription;
        }

        int incrementAndGetRefCount() {
            return this.refCount.incrementAndGet();
        }

        void decrementRefCount() {
            this.refCount.decrementAndGet();
        }

        int getRefCount() {
            return this.refCount.get();
        }

        public String toString() {
            return "MantisServerSubscriptionWrapper{ subscription=" + this.subscription + ", refCount=" + this.refCount + '}';
        }
    }

    public static class Builder {
        String prefix = null;

        Builder() {
        }

        Builder withClientIdPrefix(String prefix) {
            ObjectUtils.checkNotNull("prefix", prefix);
            this.prefix = prefix;
            return this;
        }

        QueryMap build() {
            ObjectUtils.checkNotNull("prefix", this.prefix);
            return new QueryMap(this.prefix);
        }
    }
}

