/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connectors.publish.core;

import io.mantisrx.connectors.publish.core.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import rx.functions.Func1;

public class EventFilter
implements Func1<Map<String, List<String>>, Func1<String, Boolean>> {
    private static final Logger LOGGER = Logger.getLogger(EventFilter.class);
    private final String clientId;

    public EventFilter(String clientId) {
        ObjectUtils.checkNotNull("clientId", clientId);
        this.clientId = clientId;
    }

    public Func1<String, Boolean> call(Map<String, List<String>> parameters) {
        Func1 filter = t1 -> true;
        if (parameters != null) {
            if (parameters.containsKey("filter")) {
                String filterBy = parameters.get("filter").get(0);
                List<String> terms = this.convertCommaSeparatedEventsToList(filterBy);
                LOGGER.info((Object)("terms: " + terms));
                filter = new SourceEventFilter(terms);
            } else if (parameters.containsKey("subscriptionId")) {
                String subId = parameters.get("subscriptionId").get(0);
                ArrayList<String> terms = new ArrayList<String>();
                terms.add(this.clientId + "_" + subId);
                filter = new SourceEventFilter(terms);
            }
            return filter;
        }
        return filter;
    }

    private List<String> convertCommaSeparatedEventsToList(String filterBy) {
        List<String> terms = new ArrayList<String>();
        if (filterBy != null && !filterBy.isEmpty()) {
            terms = Arrays.asList(filterBy.split("\\s*,\\s*"));
        }
        return terms;
    }

    private static class SourceEventFilter
    implements Func1<String, Boolean> {
        private List<String> terms;

        public SourceEventFilter(List<String> terms) {
            this.terms = terms;
            LOGGER.info((Object)("Initiated with terms" + terms));
        }

        public Boolean call(String data) {
            boolean match = true;
            if (data != null && !data.isEmpty()) {
                for (String term : this.terms) {
                    if (data.contains(term)) continue;
                    match = false;
                    break;
                }
            } else {
                match = false;
            }
            return match;
        }
    }
}

