/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka.source.checkpoint.trigger;

import io.mantisrx.connector.kafka.source.MantisKafkaSourceConfig;
import io.mantisrx.connector.kafka.source.checkpoint.trigger.CheckpointTrigger;
import io.mantisrx.connector.kafka.source.checkpoint.trigger.CheckpointingDisabledTrigger;
import io.mantisrx.connector.kafka.source.checkpoint.trigger.CountingCheckpointTrigger;

public final class CheckpointTriggerFactory {
    private CheckpointTriggerFactory() {
    }

    public static CheckpointTrigger getNewInstance(MantisKafkaSourceConfig kafkaSourceConfig) {
        switch (kafkaSourceConfig.getCheckpointStrategy()) {
            case "offsetsOnlyDefaultKafka": {
                return new CountingCheckpointTrigger(kafkaSourceConfig.getMaxBytesInProcessing(), kafkaSourceConfig.getCheckpointIntervalMs());
            }
        }
        return new CheckpointingDisabledTrigger();
    }
}

