/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka.source;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.mantisrx.runtime.parameter.Parameters;
import io.mantisrx.runtime.parameter.type.StringParameter;
import io.mantisrx.runtime.parameter.validator.Validators;
import io.mantisrx.shaded.com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisKafkaConsumerConfig
extends ConsumerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisKafkaConsumerConfig.class);
    public static final String DEFAULT_AUTO_OFFSET_RESET = "latest";
    public static final String DEFAULT_AUTO_COMMIT_ENABLED = "false";
    public static final String DEFAULT_BOOTSTRAP_SERVERS_CONFIG = "localhost:9092";
    public static final int DEFAULT_AUTO_COMMIT_INTERVAL_MS = 5000;
    public static final int DEFAULT_HEARTBEAT_INTERVAL_MS = 3000;
    public static final int DEFAULT_SESSION_TIMEOUT_MS = 10000;
    public static final int DEFAULT_FETCH_MIN_BYTES = 1024;
    public static final int DEFAULT_FETCH_MAX_WAIT_MS = 100;
    public static final int DEFAULT_REQUEST_TIMEOUT_MS = 40000;
    public static final int DEFAULT_CHECKPOINT_INTERVAL_MS = 5000;
    public static final int DEFAULT_MAX_POLL_INTERVAL_MS = 300000;
    public static final int DEFAULT_MAX_POLL_RECORDS = 500;
    public static final int DEFAULT_MAX_PARTITION_FETCH_BYTES = 10000000;
    public static final int DEFAULT_RECEIVE_BUFFER_BYTES = 32768;
    public static final int DEFAULT_SEND_BUFFER_BYTES = 131072;
    public static final Class<StringDeserializer> DEFAULT_KEY_DESERIALIZER = StringDeserializer.class;
    public static final Class<ByteArrayDeserializer> DEFAULT_VALUE_DESERIALIZER = ByteArrayDeserializer.class;

    public MantisKafkaConsumerConfig(Map<String, Object> props, Context context) {
        super(MantisKafkaConsumerConfig.applyJobParamOverrides(context, props));
    }

    public MantisKafkaConsumerConfig(Context context) {
        this(MantisKafkaConsumerConfig.defaultProps(), context);
    }

    public static Map<String, Object> defaultProps() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("enable.auto.commit", DEFAULT_AUTO_COMMIT_ENABLED);
        props.put("auto.commit.interval.ms", String.valueOf(5000));
        props.put("auto.offset.reset", DEFAULT_AUTO_OFFSET_RESET);
        props.put("fetch.max.wait.ms", String.valueOf(100));
        props.put("fetch.min.bytes", String.valueOf(1024));
        props.put("heartbeat.interval.ms", String.valueOf(3000));
        props.put("session.timeout.ms", String.valueOf(10000));
        props.put("key.deserializer", DEFAULT_KEY_DESERIALIZER);
        props.put("value.deserializer", DEFAULT_VALUE_DESERIALIZER);
        props.put("max.partition.fetch.bytes", String.valueOf(10000000));
        props.put("receive.buffer.bytes", String.valueOf(32768));
        props.put("send.buffer.bytes", String.valueOf(131072));
        props.put("bootstrap.servers", DEFAULT_BOOTSTRAP_SERVERS_CONFIG);
        props.put("metric.reporters", JmxReporter.class.getName());
        props.put("request.timeout.ms", String.valueOf(40000));
        props.put("max.poll.records", String.valueOf(500));
        props.put("max.poll.interval.ms", String.valueOf(300000));
        props.put("partition.assignment.strategy", RangeAssignor.class.getName());
        return props;
    }

    @VisibleForTesting
    static String getGroupId() {
        String jobId = System.getenv("JOB_ID");
        if (jobId != null && !jobId.isEmpty()) {
            LOGGER.info("default consumer groupId to {} if not overridden by job param", (Object)("mantis-kafka-source-" + jobId));
            return "mantis-kafka-source-" + jobId;
        }
        return "mantis-kafka-source-fallback-consumer-id";
    }

    private static Map<String, Object> applyJobParamOverrides(Context context, Map<String, Object> parsedValues) {
        Parameters parameters = context.getParameters();
        if (!parsedValues.containsKey("group.id")) {
            String consumerGroupId = (String)parameters.get("kafka.source.consumer.group.id", (Object)MantisKafkaConsumerConfig.getGroupId());
            parsedValues.put("group.id", consumerGroupId);
        }
        for (String key : MantisKafkaConsumerConfig.configNames()) {
            Object value = parameters.get("kafka.source.consumer." + key, null);
            if (value == null) continue;
            LOGGER.info("job param override for key {} -> {}", (Object)key, value);
            parsedValues.put(key, value);
        }
        return parsedValues;
    }

    public static List<ParameterDefinition<?>> getJobParameterDefinitions() {
        ArrayList params = new ArrayList();
        Map<String, Object> defaultProps = MantisKafkaConsumerConfig.defaultProps();
        for (String key : MantisKafkaConsumerConfig.configNames()) {
            ParameterDefinition.Builder builder = new StringParameter().name("kafka.source.consumer." + key).validator(Validators.alwaysPass()).description("kafka.source.consumer." + key);
            if (defaultProps.containsKey(key)) {
                Object value = defaultProps.get(key);
                builder = value instanceof Class ? builder.defaultValue((Object)((Class)value).getCanonicalName()) : builder.defaultValue((Object)((String)value));
            }
            params.add(builder.build());
        }
        return params;
    }

    public String getConsumerConfigStr() {
        return this.values().toString();
    }

    public Map<String, Object> getConsumerProperties() {
        return this.values().entrySet().stream().filter(x -> x.getKey() != null && x.getValue() != null).collect(Collectors.toMap(x -> (String)x.getKey(), x -> x.getValue()));
    }
}

