/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class KafkaData {
    private final String topic;
    private final int partition;
    private final long offset;
    private final byte[] rawBytes;
    private volatile Optional<Map<String, Object>> parsedEvent;
    private final Optional<String> key;
    private final String streamId;
    private int mantisKafkaConsumerId;

    public KafkaData(String topic, int partition, long offset, byte[] rawBytes, Optional<Map<String, Object>> parsedEvent, Optional<String> key, int mantisKafkaConsumerId) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.rawBytes = rawBytes;
        this.parsedEvent = parsedEvent;
        this.key = key;
        this.mantisKafkaConsumerId = mantisKafkaConsumerId;
        this.streamId = topic + '-' + partition;
    }

    public KafkaData(ConsumerRecord<String, byte[]> m, Optional<Map<String, Object>> parsedEvent, Optional<String> key, int mantisKafkaConsumerId) {
        this(m.topic(), m.partition(), m.offset(), (byte[])m.value(), parsedEvent, key, mantisKafkaConsumerId);
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getMantisKafkaConsumerId() {
        return this.mantisKafkaConsumerId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaData kafkaData = (KafkaData)o;
        return this.partition == kafkaData.partition && this.offset == kafkaData.offset && this.mantisKafkaConsumerId == kafkaData.mantisKafkaConsumerId && this.topic.equals(kafkaData.topic) && Arrays.equals(this.rawBytes, kafkaData.rawBytes) && this.parsedEvent.equals(kafkaData.parsedEvent) && this.key.equals(kafkaData.key);
    }

    public int hashCode() {
        int result = Objects.hash(this.topic, this.partition, this.offset, this.parsedEvent, this.key, this.mantisKafkaConsumerId);
        result = 31 * result + Arrays.hashCode(this.rawBytes);
        return result;
    }

    public Optional<Map<String, Object>> getParsedEvent() {
        return this.parsedEvent;
    }

    public void setParsedEvent(Map<String, Object> parsedEvent) {
        this.parsedEvent = Optional.ofNullable(parsedEvent);
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public String toString() {
        return "KafkaData{topic='" + this.topic + '\'' + ", partition=" + this.partition + ", offset=" + this.offset + ", rawBytes=" + Arrays.toString(this.rawBytes) + ", parsedEvent=" + this.parsedEvent + ", key=" + this.key + '}';
    }
}

