/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka.source.checkpoint.strategy;

import io.mantisrx.connector.kafka.source.checkpoint.strategy.CheckpointStrategy;
import io.mantisrx.connector.kafka.source.serde.OffsetAndMetadataDeserializer;
import io.mantisrx.connector.kafka.source.serde.OffsetAndMetadataSerializer;
import io.mantisrx.runtime.Context;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.Module;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.mantisrx.shaded.com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedOffsetCheckpointStrategy
implements CheckpointStrategy<OffsetAndMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedOffsetCheckpointStrategy.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String DEFAULT_CHECKPOINT_DIR = "/tmp/FileBasedOffsetCheckpointStrategy";
    public static final String CHECKPOINT_DIR_PROP = "checkpointDirectory";
    private final AtomicReference<String> checkpointDir = new AtomicReference<Object>(null);

    private String filePath(TopicPartition tp) {
        return this.checkpointDir.get() + "/" + tp.topic().concat("-").concat(String.valueOf(tp.partition()));
    }

    @Override
    public void init(Context context) {
        String checkptDir = (String)context.getParameters().get(CHECKPOINT_DIR_PROP);
        this.checkpointDir.compareAndSet(null, checkptDir);
        this.createDirectoryIfDoesNotExist(this.checkpointDir.get());
    }

    @Override
    public boolean persistCheckpoint(Map<TopicPartition, OffsetAndMetadata> checkpoint) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : checkpoint.entrySet()) {
            TopicPartition tp = entry.getKey();
            Path filePath = Paths.get(this.filePath(tp), new String[0]);
            try {
                if (Files.notExists(filePath, new LinkOption[0])) {
                    LOGGER.info("file {} does not exist, creating one", (Object)filePath);
                    Files.createFile(filePath, new FileAttribute[0]);
                }
                Files.write(filePath, Collections.singletonList(MAPPER.writeValueAsString((Object)entry.getValue())), new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("error writing checkpoint {} to file {}", new Object[]{entry.getValue(), filePath, e});
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public Optional<OffsetAndMetadata> loadCheckpoint(TopicPartition tp) {
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.filePath(tp), new String[0]));
            if (!lines.isEmpty()) {
                String checkpointString = lines.get(0);
                LOGGER.info("read from file {}", (Object)checkpointString);
                return Optional.ofNullable(MAPPER.readValue(checkpointString, OffsetAndMetadata.class));
            }
        }
        catch (IOException e) {
            LOGGER.error("error loading checkpoint from file {}", (Object)this.filePath(tp), (Object)e);
        }
        return Optional.empty();
    }

    @Override
    public void init(Map<String, String> properties) {
        if (!properties.containsKey(CHECKPOINT_DIR_PROP) || Strings.isNullOrEmpty((String)properties.get(CHECKPOINT_DIR_PROP))) {
            throw new IllegalArgumentException("missing required property checkpointDirectory");
        }
        String checkptDir = properties.get(CHECKPOINT_DIR_PROP);
        this.checkpointDir.compareAndSet(null, checkptDir);
        this.createDirectoryIfDoesNotExist(this.checkpointDir.get());
    }

    private void createDirectoryIfDoesNotExist(String dir) {
        if (Files.notExists(Paths.get(dir, new String[0]), new LinkOption[0])) {
            LOGGER.info("file {} does not exist, creating one", (Object)dir);
            try {
                Files.createDirectory(Paths.get(dir, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("failed to create checkpoint directory {}", (Object)dir);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Map<TopicPartition, Optional<OffsetAndMetadata>> loadCheckpoints(List<TopicPartition> tpList) {
        HashMap<TopicPartition, Optional<OffsetAndMetadata>> tpChkMap = new HashMap<TopicPartition, Optional<OffsetAndMetadata>>();
        for (TopicPartition tp : tpList) {
            tpChkMap.put(tp, this.loadCheckpoint(tp));
        }
        return tpChkMap;
    }

    @Override
    public String type() {
        return "fileBasedOffsetCheckpointing";
    }

    static {
        MAPPER.registerModule((Module)new Jdk8Module());
        SimpleModule offsetAndMetadataModule = new SimpleModule();
        offsetAndMetadataModule.addSerializer(OffsetAndMetadata.class, (JsonSerializer)new OffsetAndMetadataSerializer());
        offsetAndMetadataModule.addDeserializer(OffsetAndMetadata.class, (JsonDeserializer)new OffsetAndMetadataDeserializer());
        MAPPER.registerModule((Module)offsetAndMetadataModule);
    }
}

