/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka;

import io.mantisrx.connector.kafka.KafkaData;

public class KafkaDataNotification {
    private final KafkaData value;
    private final Kind kind;
    private final Throwable error;
    private long elapsedMillis;

    public static KafkaDataNotification ack(KafkaData event, long elapsedMillis) {
        return new KafkaDataNotification(event, Kind.ACK, null, elapsedMillis);
    }

    public static KafkaDataNotification nack(KafkaData event, long elapsedMillis) {
        return new KafkaDataNotification(event, Kind.NACK, null, elapsedMillis);
    }

    public static KafkaDataNotification error(KafkaData request, Throwable t, long elapsedMillis) {
        return new KafkaDataNotification(request, Kind.ERR, t, elapsedMillis);
    }

    protected KafkaDataNotification(KafkaData value, Kind kind, Throwable error, long elapsedMillis) {
        this.value = value;
        this.kind = kind;
        this.error = error;
        this.elapsedMillis = elapsedMillis;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Kind getKind() {
        return this.kind;
    }

    public KafkaData getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isError() {
        return this.kind.equals((Object)Kind.ERR);
    }

    public boolean isSuccess() {
        return this.kind.equals((Object)Kind.ACK);
    }

    public long getElapsed() {
        return this.elapsedMillis;
    }

    public static enum Kind {
        ACK,
        NACK,
        ERR;

    }
}

