/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka.sink;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.mantisrx.runtime.parameter.Parameters;
import io.mantisrx.runtime.parameter.type.StringParameter;
import io.mantisrx.runtime.parameter.validator.Validators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisKafkaProducerConfig
extends ProducerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisKafkaProducerConfig.class);
    public static final String DEFAULT_BOOTSTRAP_SERVERS_CONFIG = "localhost:9092";
    public static final String DEFAULT_ACKS_CONFIG = "all";
    public static final int DEFAULT_RETRIES_CONFIG = 1;

    public MantisKafkaProducerConfig(Map<String, Object> props, Context context) {
        super(MantisKafkaProducerConfig.applyJobParamOverrides(context, props));
    }

    public MantisKafkaProducerConfig(Context context) {
        this(MantisKafkaProducerConfig.defaultProps(), context);
    }

    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        return super.postProcessParsedConfig(parsedValues);
    }

    public static Map<String, Object> defaultProps() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("key.serializer", ByteArraySerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        props.put("bootstrap.servers", DEFAULT_BOOTSTRAP_SERVERS_CONFIG);
        props.put("metric.reporters", JmxReporter.class.getName());
        props.put("acks", DEFAULT_ACKS_CONFIG);
        props.put("retries", 1);
        return props;
    }

    private static Map<String, Object> applyJobParamOverrides(Context context, Map<String, Object> parsedValues) {
        Parameters parameters = context.getParameters();
        Map<String, Object> defaultProps = MantisKafkaProducerConfig.defaultProps();
        for (String key : MantisKafkaProducerConfig.configNames()) {
            Object value = parameters.get("kafka.sink.producer." + key, null);
            if (value == null) continue;
            LOGGER.info("job param override for key {} -> {}", (Object)key, value);
            parsedValues.put(key, value);
        }
        String bootstrapBrokers = (String)parameters.get("kafka.sink.producer.bootstrap.servers", defaultProps.get("bootstrap.servers"));
        parsedValues.put("bootstrap.servers", bootstrapBrokers);
        String clientId = (String)parameters.get("kafka.sink.producer.client.id", (Object)context.getJobId());
        parsedValues.put("client.id", clientId);
        return parsedValues;
    }

    public Map<String, Object> getProducerProperties() {
        return this.values().entrySet().stream().filter(x -> x.getKey() != null && x.getValue() != null).collect(Collectors.toMap(x -> (String)x.getKey(), x -> x.getValue()));
    }

    public static List<ParameterDefinition<?>> getJobParameterDefinitions() {
        ArrayList params = new ArrayList();
        Map<String, Object> defaultProps = MantisKafkaProducerConfig.defaultProps();
        for (String key : MantisKafkaProducerConfig.configNames()) {
            ParameterDefinition.Builder builder = new StringParameter().name("kafka.sink.producer." + key).validator(Validators.alwaysPass()).description("kafka.sink.producer." + key);
            if (defaultProps.containsKey(key)) {
                builder = builder.defaultValue((Object)defaultProps.get(key).toString());
            }
            params.add(builder.build());
        }
        return params;
    }
}

