/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka.source;

import com.google.common.base.Splitter;
import io.mantisrx.connector.kafka.source.MantisKafkaConsumerConfig;
import io.mantisrx.connector.kafka.source.serde.ParserType;
import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.parameter.Parameters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisKafkaSourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisKafkaSourceConfig.class);
    public static final int DEFAULT_CONSUMER_POLL_TIMEOUT_MS = 100;
    public static final int DEFAULT_RETRY_CHECKPOINT_CHECK_DELAY_MS = 20;
    public static final boolean DEFAULT_ENABLE_STATIC_PARTITION_ASSIGN = false;
    public static final int CONSUMER_RECORD_OVERHEAD_BYTES = 100;
    public static final int DEFAULT_MAX_BYTES_IN_PROCESSING = 128000000;
    public static final int DEFAULT_NUM_KAFKA_CONSUMER_PER_WORKER = 1;
    public static final boolean DEFAULT_PARSE_MSG_IN_SOURCE = true;
    private final List<String> topics;
    private final int numConsumerInstances;
    private final int consumerPollTimeoutMs;
    private final int maxBytesInProcessing;
    private final String messageParserType;
    private final String checkpointStrategy;
    private final Boolean parseMessageInSource;
    private final int retryCheckpointCheckDelayMs;
    private final int checkpointIntervalMs;
    private final Boolean staticPartitionAssignmentEnabled;
    private final Optional<Map<String, Integer>> topicPartitionCounts;
    private final MantisKafkaConsumerConfig consumerConfig;

    public MantisKafkaSourceConfig(Context context) {
        Parameters parameters = context.getParameters();
        String topicStr = (String)parameters.get("kafka.source.consumer.topic");
        this.topics = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)topicStr);
        this.numConsumerInstances = (Integer)parameters.get("numKafkaConsumerPerWorker", (Object)1);
        this.consumerPollTimeoutMs = (Integer)parameters.get("consumerPollTimeoutMs", (Object)100);
        this.maxBytesInProcessing = (Integer)parameters.get("maxBytesInProcessing", (Object)128000000);
        this.messageParserType = (String)parameters.get("messageParserType", (Object)ParserType.SIMPLE_JSON.getPropName());
        this.checkpointStrategy = (String)parameters.get("checkpointStrategy", (Object)"disableCheckpointing");
        this.parseMessageInSource = (boolean)((Boolean)parameters.get("parseMessageInKafkaConsumerThread", (Object)true));
        this.retryCheckpointCheckDelayMs = (Integer)parameters.get("retryCheckpointCheckDelayMs", (Object)20);
        this.checkpointIntervalMs = (Integer)parameters.get("checkpointIntervalMs", (Object)5000);
        this.staticPartitionAssignmentEnabled = (boolean)((Boolean)parameters.get("enableStaticPartitionAssign", (Object)false));
        if (this.staticPartitionAssignmentEnabled.booleanValue()) {
            String topicPartitionsStr = (String)parameters.get("numPartitionsPerTopic", (Object)"");
            this.topicPartitionCounts = Optional.ofNullable(this.getTopicPartitionCounts(topicPartitionsStr, this.topics));
        } else {
            this.topicPartitionCounts = Optional.empty();
        }
        this.consumerConfig = new MantisKafkaConsumerConfig(context);
        LOGGER.info("checkpointStrategy: {} numConsumerInstances: {} topics: {} consumerPollTimeoutMs: {} retryCheckpointCheckDelayMs {} consumer config: {}", new Object[]{this.checkpointStrategy, this.numConsumerInstances, this.topics, this.consumerPollTimeoutMs, this.retryCheckpointCheckDelayMs, this.consumerConfig.values().toString()});
    }

    private Map<String, Integer> getTopicPartitionCounts(String topicPartitionsStr, List<String> topicList) {
        List topicPartitionCountList = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)topicPartitionsStr);
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        for (String tp : topicPartitionCountList) {
            String[] topicPartitionCount = tp.split(":");
            if (topicPartitionCount.length == 2) {
                String topic = topicPartitionCount[0];
                if (topicList.contains(topic)) {
                    topicPartitionCounts.put(topic, Integer.parseInt(topicPartitionCount[1]));
                    continue;
                }
                String errorMsg = String.format("topic %s specified in Job Parameter '%s' does not match topics specified for Job Parameter '%s'", topic, "numPartitionsPerTopic", "kafka.source.consumer.topic");
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            String errorMsg = String.format("failed to parse topic partition count string %s", tp);
            LOGGER.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        Set partitionCountTopics = topicPartitionCounts.keySet();
        if (!partitionCountTopics.containsAll(topicList) || !topicList.containsAll(partitionCountTopics)) {
            String errorMsg = String.format("topics '%s' specified for Job Parameter '%s' don't match topics '%s' specified for Job Parameter '%s'", partitionCountTopics, "numPartitionsPerTopic", topicList, "kafka.source.consumer.topic");
            LOGGER.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        LOGGER.info("enableStaticPartitionAssignment: {} [ topic partition counts: {} ]", (Object)this.staticPartitionAssignmentEnabled, topicPartitionCounts);
        return topicPartitionCounts;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public int getNumConsumerInstances() {
        return this.numConsumerInstances;
    }

    public int getConsumerPollTimeoutMs() {
        return this.consumerPollTimeoutMs;
    }

    public int getMaxBytesInProcessing() {
        return this.maxBytesInProcessing;
    }

    public String getMessageParserType() {
        return this.messageParserType;
    }

    public String getCheckpointStrategy() {
        return this.checkpointStrategy;
    }

    public Boolean getParseMessageInSource() {
        return this.parseMessageInSource;
    }

    public int getRetryCheckpointCheckDelayMs() {
        return this.retryCheckpointCheckDelayMs;
    }

    public int getCheckpointIntervalMs() {
        return this.checkpointIntervalMs;
    }

    public Boolean getStaticPartitionAssignmentEnabled() {
        return this.staticPartitionAssignmentEnabled;
    }

    public Optional<Map<String, Integer>> getTopicPartitionCounts() {
        return this.topicPartitionCounts;
    }

    public MantisKafkaConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }
}

